/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.cl;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import jodd.util.SystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedURLClassLoader
extends URLClassLoader {
    protected ClassLoader parentClassLoader;
    protected String[] systemPackages;
    protected String[] loaderPackages;
    protected boolean parentFirst;

    public ExtendedURLClassLoader(URL[] classpath, ClassLoader parent) {
        this(classpath, parent, true);
    }

    public ExtendedURLClassLoader(URL[] classpath, ClassLoader parent, boolean parentFirst) {
        super(classpath, parent);
        this.parentFirst = parentFirst;
        if (parent == null) {
            parent = ExtendedURLClassLoader.getSystemClassLoader();
        }
        this.parentClassLoader = parent;
        this.systemPackages = new String[0];
        this.loaderPackages = new String[0];
        this.addSystemPackage(SystemUtil.getJrePackages());
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    public void addSystemPackage(String ... packages) {
        this.systemPackages = this.joinPackages(this.systemPackages, packages);
    }

    public void addLoaderPackage(String ... packages) {
        this.loaderPackages = this.joinPackages(this.loaderPackages, packages);
    }

    protected String[] joinPackages(String[] dest, String[] src) {
        int len = dest.length;
        String[] result = new String[len + src.length];
        System.arraycopy(dest, 0, result, 0, len);
        for (int i = 0; i < src.length; ++i) {
            String pck = src[i];
            result[len + i] = pck = pck + (pck.endsWith(".") ? "" : ".");
        }
        return result;
    }

    protected boolean isInPackageList(String name, String[] packages) {
        for (String pck : packages) {
            if (!name.startsWith(pck)) continue;
            return true;
        }
        return false;
    }

    protected boolean isParentFirst(String resourceName) {
        boolean useParentFirst = this.parentFirst;
        if (this.isInPackageList(resourceName, this.systemPackages)) {
            useParentFirst = true;
        }
        if (this.isInPackageList(resourceName, this.loaderPackages)) {
            useParentFirst = false;
        }
        return useParentFirst;
    }

    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(className);
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        boolean loadUsingParentFirst = this.isParentFirst(className);
        if (loadUsingParentFirst) {
            try {
                c = this.parentClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null) {
                c = this.findClass(className);
            }
        } else {
            try {
                c = this.findClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null) {
                c = this.parentClassLoader.loadClass(className);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String resourceName) {
        URL url;
        boolean loadUsingParentFirst = this.isParentFirst(resourceName);
        if (loadUsingParentFirst) {
            url = this.parentClassLoader.getResource(resourceName);
            if (url == null) {
                url = this.findResource(resourceName);
            }
        } else {
            url = this.findResource(resourceName);
            if (url == null) {
                url = this.parentClassLoader.getResource(resourceName);
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String resourceName) throws IOException {
        final ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> localUrls = this.findResources(resourceName);
        Enumeration<URL> parentUrls = this.parentClassLoader.getResources(resourceName);
        boolean loadUsingParentFirst = this.isParentFirst(resourceName);
        if (loadUsingParentFirst) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        } else {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iterator;
            {
                this.iterator = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iterator.next();
            }
        };
    }
}

