/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.StreamUtil;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtil {
    public static Object clone(Object source) throws CloneNotSupportedException {
        if (source == null) {
            return null;
        }
        try {
            return ReflectUtil.invokeDeclared(source, "clone", new Class[0], new Object[0]);
        }
        catch (Exception ex) {
            throw new CloneNotSupportedException("Can't clone() the object: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T cloneViaSerialization(T obj) throws IOException, ClassNotFoundException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object objCopy = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            out.flush();
            byte[] bytes = bos.toByteArray();
            in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            objCopy = in.readObject();
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(out);
        StreamUtil.close(in);
        return (T)((Serializable)objCopy);
    }

    public static void writeObject(String dest, Object object) throws IOException {
        ObjectUtil.writeObject(new File(dest), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(File dest, Object object) throws IOException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(dest);
            bos = new BufferedOutputStream(fos);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
        }
        catch (Throwable throwable) {
            StreamUtil.close(oos);
            StreamUtil.close(bos);
            StreamUtil.close(fos);
            throw throwable;
        }
        StreamUtil.close(oos);
        StreamUtil.close(bos);
        StreamUtil.close(fos);
    }

    public static Object readObject(String source) throws IOException, ClassNotFoundException {
        return ObjectUtil.readObject(new File(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(File source) throws IOException, ClassNotFoundException {
        Object result = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(source);
            bis = new BufferedInputStream(fis);
            ois = new ObjectInputStream(bis);
            result = ois.readObject();
        }
        catch (Throwable throwable) {
            StreamUtil.close(ois);
            StreamUtil.close(bis);
            StreamUtil.close(fis);
            throw throwable;
        }
        StreamUtil.close(ois);
        StreamUtil.close(bis);
        StreamUtil.close(fis);
        return result;
    }

    public static byte[] objectToByteArray(Object obj) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
        }
        catch (Throwable throwable) {
            StreamUtil.close(oos);
            throw throwable;
        }
        StreamUtil.close(oos);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object byteArrayToObject(byte[] data) throws IOException, ClassNotFoundException {
        Object retObj = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            retObj = ois.readObject();
        }
        catch (Throwable throwable) {
            StreamUtil.close(ois);
            throw throwable;
        }
        StreamUtil.close(ois);
        return retObj;
    }
}

