/*
 * Decompiled with CFR 0.152.
 */
package jodd;

import java.lang.reflect.Field;
import jodd.JoddModule;
import jodd.exception.UncheckedException;

public class Jodd {
    private static int ndx = 0;
    public static final int CORE = ndx++;
    public static final int BEAN = ndx++;
    public static final int DB = ndx++;
    public static final int HTTP = ndx++;
    public static final int INTROSPECTOR = ndx++;
    public static final int JSON = ndx++;
    public static final int JTX = ndx++;
    public static final int LAGARTO = ndx++;
    public static final int MADVOC = ndx++;
    public static final int MAIL = ndx++;
    public static final int PETITE = ndx++;
    public static final int PROPS = ndx++;
    public static final int PROXETTA = ndx++;
    public static final int SERVLET = ndx++;
    public static final int UPLOAD = ndx++;
    public static final int VTOR = ndx++;
    private static final Object[] MODULES = new Object[ndx];
    private static final String[] NAMES = new String[ndx];

    public static void init(Class joddModuleClass) {
        String name = joddModuleClass.getName();
        int moduleId = -1;
        for (int i = 0; i < NAMES.length; ++i) {
            String moduleName = NAMES[i];
            if (!name.equals(moduleName)) continue;
            moduleId = i;
            break;
        }
        if (moduleId == -1) {
            throw new IllegalArgumentException("Invalid module: " + joddModuleClass);
        }
        Object module = MODULES[moduleId];
        if (module != null && module.getClass() == joddModuleClass) {
            return;
        }
        Jodd.MODULES[moduleId] = joddModuleClass;
        Jodd.updateModuleInstance(moduleId);
    }

    public static void initAllModules() {
        Field[] fields = Jodd.class.getFields();
        ClassLoader classLoader = Jodd.class.getClassLoader();
        for (Field field : fields) {
            String moduleClass;
            try {
                int index = (Integer)field.get(null);
            }
            catch (IllegalAccessException iaex) {
                throw new UncheckedException(iaex);
            }
            String moduleName = field.getName();
            String packageName = moduleName.toLowerCase();
            moduleName = moduleName.substring(0, 1).toUpperCase() + moduleName.substring(1, moduleName.length()).toLowerCase();
            Jodd.NAMES[index] = moduleClass = "jodd." + packageName + ".Jodd" + moduleName;
            try {
                Jodd.MODULES[index] = classLoader.loadClass(moduleClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (int i = 0; i < MODULES.length; ++i) {
            Jodd.updateModuleInstance(i);
        }
    }

    private static void updateModuleInstance(int moduleId) {
        Object module = MODULES[moduleId];
        if (module == null) {
            return;
        }
        if (module instanceof Class) {
            Class type = (Class)module;
            try {
                Jodd.MODULES[moduleId] = module = type.newInstance();
                if (module instanceof JoddModule) {
                    ((JoddModule)module).start();
                }
            }
            catch (Exception ex) {
                Jodd.MODULES[moduleId] = null;
                throw new UncheckedException(ex);
            }
        }
    }

    public static boolean isModuleLoaded(int moduleNdx) {
        return MODULES[moduleNdx] != null;
    }

    public static Object getModule(int moduleNdx) {
        return MODULES[moduleNdx];
    }

    static {
        Jodd.initAllModules();
    }
}

