/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

public class HtmlEncoder {
    private static final int LEN = 161;
    private static final int LEN_XML = 64;
    private static final char[][] TEXT;
    private static final char[][] TEXT_XML;
    private static final char[] QUOT;

    public static String attribute(CharSequence value) {
        return HtmlEncoder._encodeHtml(value, '\"', QUOT);
    }

    public static String text(CharSequence text) {
        return HtmlEncoder._encodeHtml(text, '\u0000', null);
    }

    private static String _encodeHtml(CharSequence text, char addonChar, char[] addonCharReplacement) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '\u00a1') {
                char[] encoded = TEXT[c];
                if (encoded == null) continue;
                if (c == addonChar) {
                    buffer.append(addonCharReplacement);
                    continue;
                }
                buffer.append(encoded);
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff' || c == '\ufffe' || c == '\uffff') continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String xml(CharSequence text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '@') {
                buffer.append(TEXT_XML[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    static {
        int i;
        TEXT = new char[161][];
        TEXT_XML = new char[64][];
        QUOT = "&quot;".toCharArray();
        for (i = 0; i < 161; ++i) {
            HtmlEncoder.TEXT[i] = new char[]{(char)i};
        }
        for (i = 0; i < 64; ++i) {
            HtmlEncoder.TEXT_XML[i] = new char[]{(char)i};
        }
        for (i = 0; i <= 31; ++i) {
            if (i == 9 || i == 10 || i == 13) continue;
            HtmlEncoder.TEXT[i] = null;
        }
        HtmlEncoder.TEXT[127] = null;
        for (i = 128; i <= 159; ++i) {
            HtmlEncoder.TEXT[i] = null;
        }
        HtmlEncoder.TEXT[38] = "&amp;".toCharArray();
        HtmlEncoder.TEXT[60] = "&lt;".toCharArray();
        HtmlEncoder.TEXT[62] = "&gt;".toCharArray();
        HtmlEncoder.TEXT[160] = "&nbsp;".toCharArray();
        HtmlEncoder.TEXT_XML[38] = "&amp;".toCharArray();
        HtmlEncoder.TEXT_XML[34] = "&quot;".toCharArray();
        HtmlEncoder.TEXT_XML[39] = "&#39;".toCharArray();
        HtmlEncoder.TEXT_XML[60] = "&lt;".toCharArray();
        HtmlEncoder.TEXT_XML[62] = "&gt;".toCharArray();
    }
}

