/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.UnsupportedEncodingException;
import jodd.JoddCore;

public class CharUtil {
    public static char toChar(byte b) {
        return (char)(b & 0xFF);
    }

    public static byte[] toSimpleByteArray(char[] carr) {
        byte[] barr = new byte[carr.length];
        for (int i = 0; i < carr.length; ++i) {
            barr[i] = (byte)carr[i];
        }
        return barr;
    }

    public static byte[] toSimpleByteArray(CharSequence charSequence) {
        byte[] barr = new byte[charSequence.length()];
        for (int i = 0; i < barr.length; ++i) {
            barr[i] = (byte)charSequence.charAt(i);
        }
        return barr;
    }

    public static char[] toSimpleCharArray(byte[] barr) {
        char[] carr = new char[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            carr[i] = (char)(barr[i] & 0xFF);
        }
        return carr;
    }

    public static int toAscii(char c) {
        if (c <= '\u00ff') {
            return c;
        }
        return 63;
    }

    public static byte[] toAsciiByteArray(char[] carr) {
        byte[] barr = new byte[carr.length];
        for (int i = 0; i < carr.length; ++i) {
            barr[i] = (byte)(carr[i] <= '\u00ff' ? carr[i] : 63);
        }
        return barr;
    }

    public static byte[] toAsciiByteArray(CharSequence charSequence) {
        byte[] barr = new byte[charSequence.length()];
        for (int i = 0; i < barr.length; ++i) {
            int c = charSequence.charAt(i);
            barr[i] = (byte)(c <= 255 ? c : 63);
        }
        return barr;
    }

    public static byte[] toRawByteArray(char[] carr) {
        byte[] barr = new byte[carr.length << 1];
        int bpos = 0;
        for (int i = 0; i < carr.length; ++i) {
            char c = carr[i];
            barr[bpos++] = (byte)((c & 0xFF00) >> 8);
            barr[bpos++] = (byte)(c & 0xFF);
        }
        return barr;
    }

    public static char[] toRawCharArray(byte[] barr) {
        int carrLen = barr.length >> 1;
        if (carrLen << 1 < barr.length) {
            ++carrLen;
        }
        char[] carr = new char[carrLen];
        int i = 0;
        int j = 0;
        while (i < barr.length) {
            char c = (char)(barr[i] << 8);
            if (++i != barr.length) {
                c = (char)(c + (barr[i] & 0xFF));
                ++i;
            }
            carr[j++] = c;
        }
        return carr;
    }

    public static byte[] toByteArray(char[] carr) throws UnsupportedEncodingException {
        return new String(carr).getBytes(JoddCore.encoding);
    }

    public static byte[] toByteArray(char[] carr, String charset) throws UnsupportedEncodingException {
        return new String(carr).getBytes(charset);
    }

    public static char[] toCharArray(byte[] barr) throws UnsupportedEncodingException {
        return new String(barr, JoddCore.encoding).toCharArray();
    }

    public static char[] toCharArray(byte[] barr, String charset) throws UnsupportedEncodingException {
        return new String(barr, charset).toCharArray();
    }

    public static boolean equalsOne(char c, char[] match) {
        for (char aMatch : match) {
            if (c != aMatch) continue;
            return true;
        }
        return false;
    }

    public static int findFirstEqual(char[] source, int index, char[] match) {
        for (int i = index; i < source.length; ++i) {
            if (!CharUtil.equalsOne(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstEqual(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] != match) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char[] match) {
        for (int i = index; i < source.length; ++i) {
            if (CharUtil.equalsOne(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] == match) continue;
            return i;
        }
        return -1;
    }

    public static boolean isWhitespace(char c) {
        return c <= ' ';
    }

    public static boolean isLowercaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isAlphaOrDigit(char c) {
        return CharUtil.isDigit(c) || CharUtil.isAlpha(c);
    }

    public static boolean isWordChar(char c) {
        return CharUtil.isDigit(c) || CharUtil.isAlpha(c) || c == '_';
    }

    public static boolean isPropertyNameChar(char c) {
        return CharUtil.isDigit(c) || CharUtil.isAlpha(c) || c == '_' || c == '.' || c == '[' || c == ']';
    }

    public static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean isGenericDelimiter(int c) {
        switch (c) {
            case 35: 
            case 47: 
            case 58: 
            case 63: 
            case 64: 
            case 91: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isSubDelimiter(int c) {
        switch (c) {
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 59: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isReserved(char c) {
        return CharUtil.isGenericDelimiter(c) || CharUtil.isSubDelimiter(c);
    }

    protected static boolean isUnreserved(char c) {
        return CharUtil.isAlpha(c) || CharUtil.isDigit(c) || c == '-' || c == '.' || c == '_' || c == '~';
    }

    protected static boolean isPchar(char c) {
        return CharUtil.isUnreserved(c) || CharUtil.isSubDelimiter(c) || c == ':' || c == '@';
    }

    public static char toUpperAscii(char c) {
        if (CharUtil.isLowercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    public static char toLowerAscii(char c) {
        if (CharUtil.isUppercaseAlpha(c)) {
            c = (char)(c + 32);
        }
        return c;
    }

    public static int hex2int(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 55;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 87;
            }
        }
        throw new IllegalArgumentException("Not a hex: " + c);
    }
}

