/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.cl;

import java.util.Arrays;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;
import jodd.util.cl.ClassLoaderStrategy;

public class DefaultClassLoaderStrategy
implements ClassLoaderStrategy {
    public static final String[] PRIMITIVE_TYPE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    public static final Class[] PRIMITIVE_TYPES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    public static final char[] PRIMITIVE_BYTECODE_NAME = new char[]{'Z', 'B', 'C', 'D', 'F', 'I', 'J', 'S'};

    public static String prepareClassnameForLoading(String className) {
        int bracketCount = StringUtil.count(className, '[');
        if (bracketCount == 0) {
            return className;
        }
        String brackets = StringUtil.repeat('[', bracketCount);
        int bracketIndex = className.indexOf(91);
        int primitiveNdx = DefaultClassLoaderStrategy.getPrimitiveClassNameIndex(className = className.substring(0, bracketIndex));
        if (primitiveNdx >= 0) {
            className = String.valueOf(PRIMITIVE_BYTECODE_NAME[primitiveNdx]);
            return brackets + className;
        }
        return brackets + 'L' + className + ';';
    }

    private static int getPrimitiveClassNameIndex(String className) {
        int dotIndex = className.indexOf(46);
        if (dotIndex != -1) {
            return -1;
        }
        return Arrays.binarySearch(PRIMITIVE_TYPE_NAMES, className);
    }

    public Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class callerClass;
        ClassLoader callerClassLoader;
        int primitiveNdx;
        if (((className = DefaultClassLoaderStrategy.prepareClassnameForLoading(className)).indexOf(46) == -1 || className.indexOf(91) == -1) && (primitiveNdx = DefaultClassLoaderStrategy.getPrimitiveClassNameIndex(className)) >= 0) {
            return PRIMITIVE_TYPES[primitiveNdx];
        }
        try {
            if (classLoader != null) {
                return classLoader.loadClass(className);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader) {
            try {
                return currentThreadClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if ((callerClassLoader = (callerClass = ReflectUtil.getCallerClass()).getClassLoader()) != classLoader && callerClassLoader != currentThreadClassLoader) {
            try {
                return callerClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignore) {
            throw new ClassNotFoundException("Class not found: " + className);
        }
    }
}

