/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jodd.io.StreamUtil;

public class HtmlDecoder {
    private static final Map<String, Character> ENTITY_MAP;

    public static String decode(String html) {
        int ndx = html.indexOf(38);
        if (ndx == -1) {
            return html;
        }
        StringBuilder result = new StringBuilder(html.length());
        int lastIndex = 0;
        int len = html.length();
        block0: while (ndx != -1) {
            result.append(html.substring(lastIndex, ndx));
            lastIndex = ndx;
            while (html.charAt(lastIndex) != ';') {
                if (++lastIndex != len) continue;
                lastIndex = ndx;
                break block0;
            }
            if (html.charAt(ndx + 1) == '#') {
                int radix;
                char c = html.charAt(ndx + 2);
                if (c == 'x' || c == 'X') {
                    radix = 16;
                    ndx += 3;
                } else {
                    radix = 10;
                    ndx += 2;
                }
                String number = html.substring(ndx, lastIndex);
                int i = Integer.parseInt(number, radix);
                result.append((char)i);
                ++lastIndex;
            } else {
                String encodeToken = html.substring(ndx + 1, lastIndex);
                Character replacement = ENTITY_MAP.get(encodeToken);
                if (replacement == null) {
                    result.append('&');
                    lastIndex = ndx + 1;
                } else {
                    result.append(replacement.charValue());
                    ++lastIndex;
                }
            }
            ndx = html.indexOf(38, lastIndex);
        }
        result.append(html.substring(lastIndex));
        return result.toString();
    }

    static {
        Properties entityReferences = new Properties();
        String propertiesName = HtmlDecoder.class.getSimpleName() + ".properties";
        InputStream is = HtmlDecoder.class.getResourceAsStream(propertiesName);
        if (is == null) {
            throw new IllegalStateException("Missing: " + propertiesName);
        }
        try {
            entityReferences.load(is);
        }
        catch (IOException ioex) {
            throw new IllegalStateException(ioex.getMessage());
        }
        finally {
            StreamUtil.close(is);
        }
        ENTITY_MAP = new HashMap<String, Character>(entityReferences.size());
        Enumeration<?> keys = entityReferences.propertyNames();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String hex = entityReferences.getProperty(name);
            int value = Integer.parseInt(hex, 16);
            ENTITY_MAP.put(name, Character.valueOf((char)value));
        }
    }
}

