/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.lang.reflect.Array;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManagerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayConverter<T>
implements TypeConverter<T[]> {
    protected final TypeConverterManagerBean typeConverterManagerBean;
    protected final Class<T> targetComponentType;

    public ArrayConverter(TypeConverterManagerBean typeConverterManagerBean, Class<T> targetComponentType) {
        this.typeConverterManagerBean = typeConverterManagerBean;
        this.targetComponentType = targetComponentType;
    }

    @Override
    public T[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertToSingleElementArray(value);
        }
        return this.convertArray(value);
    }

    protected T convertType(Object value) {
        return this.typeConverterManagerBean.convertType(value, this.targetComponentType);
    }

    protected T[] convertToSingleElementArray(Object value) {
        Object singleElementArray = Array.newInstance(this.targetComponentType, 1);
        Array.set(singleElementArray, 0, this.convertType(value));
        return (Object[])singleElementArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected T[] convertArray(Object value) {
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (this.targetComponentType == valueComponentType) {
            return (Object[])value;
        }
        if (valueComponentType.isPrimitive()) {
            if (valueComponentType == Integer.TYPE) {
                int[] array = (int[])value;
                Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
                int i = 0;
                while (i < array.length) {
                    objArray[i] = this.convertType(array[i]);
                    ++i;
                }
                return objArray;
            }
            if (valueComponentType == Long.TYPE) {
                long[] array = (long[])value;
                Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
                int i = 0;
                while (i < array.length) {
                    objArray[i] = this.convertType(array[i]);
                    ++i;
                }
                return objArray;
            }
            if (valueComponentType == Float.TYPE) {
                float[] array = (float[])value;
                Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
                int i = 0;
                while (i < array.length) {
                    objArray[i] = this.convertType(Float.valueOf(array[i]));
                    ++i;
                }
                return objArray;
            }
            if (valueComponentType == Double.TYPE) {
                double[] array = (double[])value;
                Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
                int i = 0;
                while (i < array.length) {
                    objArray[i] = this.convertType(array[i]);
                    ++i;
                }
                return objArray;
            }
            if (valueComponentType == Short.TYPE) {
                short[] array = (short[])value;
                Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
                int i = 0;
                while (i < array.length) {
                    objArray[i] = this.convertType(array[i]);
                    ++i;
                }
                return objArray;
            }
            if (valueComponentType == Byte.TYPE) {
                byte[] array = (byte[])value;
                Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
                int i = 0;
                while (i < array.length) {
                    objArray[i] = this.convertType(array[i]);
                    ++i;
                }
                return objArray;
            }
            if (valueComponentType == Character.TYPE) {
                char[] array = (char[])value;
                Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
                int i = 0;
                while (i < array.length) {
                    objArray[i] = this.convertType(Character.valueOf(array[i]));
                    ++i;
                }
                return objArray;
            }
            if (valueComponentType != Boolean.TYPE) throw new IllegalArgumentException();
            boolean[] array = (boolean[])value;
            Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
            int i = 0;
            while (i < array.length) {
                objArray[i] = this.convertType(array[i]);
                ++i;
            }
            return objArray;
        }
        Object[] array = (Object[])value;
        Object[] objArray = (Object[])Array.newInstance(this.targetComponentType, array.length);
        int i = 0;
        while (i < array.length) {
            objArray[i] = this.convertType(array[i]);
            ++i;
        }
        return objArray;
    }
}

