/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.Map;
import jodd.bean.BeanUtil;
import jodd.bean.BeanVisitorImplBase;

public class BeanCopy
extends BeanVisitorImplBase<BeanCopy> {
    protected Object destination;
    protected boolean forced;
    protected boolean declaredTarget;
    protected boolean isTargetMap;

    public BeanCopy(Object source, Object destination) {
        this.source = source;
        this.destination = destination;
    }

    private BeanCopy(Object source) {
        this.source = source;
    }

    public static BeanCopy beans(Object source, Object destination) {
        return new BeanCopy(source, destination);
    }

    public static BeanCopy fromBean(Object source) {
        return new BeanCopy(source);
    }

    public static BeanCopy fromMap(Map source) {
        BeanCopy beanCopy = new BeanCopy(source);
        beanCopy.isSourceMap = true;
        return beanCopy;
    }

    public static BeanCopy from(Object source) {
        BeanCopy beanCopy = new BeanCopy(source);
        beanCopy.isSourceMap = source instanceof Map;
        return beanCopy;
    }

    public BeanCopy toBean(Object destination) {
        this.destination = destination;
        return this;
    }

    public BeanCopy toMap(Map destination) {
        this.destination = destination;
        this.isTargetMap = true;
        return this;
    }

    public BeanCopy to(Object destination) {
        this.destination = destination;
        this.isTargetMap = destination instanceof Map;
        return this;
    }

    @Override
    public BeanCopy declared(boolean declared) {
        this.declared = declared;
        this.declaredTarget = declared;
        return this;
    }

    public BeanCopy declared(boolean declaredSource, boolean declaredTarget) {
        this.declared = declaredSource;
        this.declaredTarget = declaredTarget;
        return this;
    }

    public BeanCopy forced(boolean forced) {
        this.forced = forced;
        return this;
    }

    public void copy() {
        this.visit();
    }

    @Override
    protected boolean visitProperty(String name, Object value) {
        if (this.isTargetMap) {
            name = "[" + name + "]";
        }
        BeanUtil.setProperty(this.destination, name, value, this.declared, this.forced, true);
        return true;
    }
}

