/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.Descriptor;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.Getter;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.Setter;

public class PropertyDescriptor
extends Descriptor {
    protected final String name;
    protected final MethodDescriptor readMethodDescriptor;
    protected final MethodDescriptor writeMethodDescriptor;
    protected final FieldDescriptor fieldDescriptor;
    protected Class type;
    protected Getter[] getters;
    protected Setter[] setters;

    public PropertyDescriptor(ClassDescriptor classDescriptor, String propertyName, FieldDescriptor fieldDescriptor) {
        super(classDescriptor, false);
        this.name = propertyName;
        this.readMethodDescriptor = null;
        this.writeMethodDescriptor = null;
        this.fieldDescriptor = fieldDescriptor;
    }

    public PropertyDescriptor(ClassDescriptor classDescriptor, String propertyName, MethodDescriptor readMethod, MethodDescriptor writeMethod) {
        super(classDescriptor, (readMethod == null || readMethod.isPublic()) & (writeMethod == null || writeMethod.isPublic()));
        this.name = propertyName;
        this.readMethodDescriptor = readMethod;
        this.writeMethodDescriptor = writeMethod;
        if (classDescriptor.isExtendedProperties()) {
            String[] prefix = classDescriptor.getPropertyFieldPrefix();
            FieldDescriptor fd = null;
            if (prefix != null) {
                String p;
                String[] arr$ = prefix;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (fd = this.findField((p = arr$[i$]) + propertyName)) == null; ++i$) {
                }
            } else {
                fd = this.findField(propertyName);
            }
            this.fieldDescriptor = fd;
        } else {
            this.fieldDescriptor = null;
        }
    }

    protected FieldDescriptor findField(String fieldName) {
        Class[] superclasses;
        FieldDescriptor fieldDescriptor = this.classDescriptor.getFieldDescriptor(fieldName, true);
        if (fieldDescriptor != null) {
            return fieldDescriptor;
        }
        for (Class superclass : superclasses = this.classDescriptor.getAllSuperclasses()) {
            ClassDescriptor classDescriptor = ClassIntrospector.lookup(superclass);
            fieldDescriptor = classDescriptor.getFieldDescriptor(fieldName, true);
            if (fieldDescriptor == null) continue;
            return fieldDescriptor;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public MethodDescriptor getReadMethodDescriptor() {
        return this.readMethodDescriptor;
    }

    public MethodDescriptor getWriteMethodDescriptor() {
        return this.writeMethodDescriptor;
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    public boolean isFieldOnly() {
        return this.readMethodDescriptor == null && this.writeMethodDescriptor == null;
    }

    public boolean isGetterOnly() {
        return this.fieldDescriptor == null && this.writeMethodDescriptor == null;
    }

    public boolean isSetterOnly() {
        return this.fieldDescriptor == null && this.readMethodDescriptor == null;
    }

    public Class getType() {
        if (this.type == null) {
            if (this.fieldDescriptor != null) {
                this.type = this.fieldDescriptor.getRawType();
            } else if (this.readMethodDescriptor != null) {
                this.type = this.readMethodDescriptor.getGetterRawType();
            } else if (this.writeMethodDescriptor != null) {
                this.type = this.writeMethodDescriptor.getSetterRawType();
            }
        }
        return this.type;
    }

    public Getter getGetter(boolean declared) {
        if (this.getters == null) {
            this.getters = new Getter[]{this.createGetter(false), this.createGetter(true)};
        }
        return this.getters[declared ? 1 : 0];
    }

    protected Getter createGetter(boolean declared) {
        if (this.readMethodDescriptor != null && this.readMethodDescriptor.matchDeclared(declared)) {
            return this.readMethodDescriptor;
        }
        if (this.fieldDescriptor != null && this.fieldDescriptor.matchDeclared(declared)) {
            return this.fieldDescriptor;
        }
        return null;
    }

    public Setter getSetter(boolean declared) {
        if (this.setters == null) {
            this.setters = new Setter[]{this.createSetter(false), this.createSetter(true)};
        }
        return this.setters[declared ? 1 : 0];
    }

    protected Setter createSetter(boolean declared) {
        if (this.writeMethodDescriptor != null && this.writeMethodDescriptor.matchDeclared(declared)) {
            return this.writeMethodDescriptor;
        }
        if (this.fieldDescriptor != null && this.fieldDescriptor.matchDeclared(declared)) {
            return this.fieldDescriptor;
        }
        return null;
    }

    public Class resolveKeyType(boolean declared) {
        FieldDescriptor fieldDescriptor;
        Class keyType = null;
        Getter getter = this.getGetter(declared);
        if (getter != null) {
            keyType = getter.getGetterRawKeyComponentType();
        }
        if (keyType == null && (fieldDescriptor = this.getFieldDescriptor()) != null) {
            keyType = fieldDescriptor.getRawKeyComponentType();
        }
        return keyType;
    }

    public Class resolveComponentType(boolean declared) {
        FieldDescriptor fieldDescriptor;
        Class componentType = null;
        Getter getter = this.getGetter(declared);
        if (getter != null) {
            componentType = getter.getGetterRawComponentType();
        }
        if (componentType == null && (fieldDescriptor = this.getFieldDescriptor()) != null) {
            componentType = fieldDescriptor.getRawComponentType();
        }
        return componentType;
    }
}

