/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerConverter
implements TypeConverter<Integer> {
    @Override
    public Integer convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Integer.class) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        try {
            String stringValue = value.toString().trim();
            if (StringUtil.startsWithChar((String)stringValue, (char)'+')) {
                stringValue = stringValue.substring(1);
            }
            return Integer.valueOf(stringValue);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

