/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import jodd.introspector.ClassDescriptor;
import jodd.introspector.Descriptor;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.Getter;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.Setter;

public class PropertyDescriptor
extends Descriptor {
    protected final String name;
    protected final MethodDescriptor readMethodDescriptor;
    protected final MethodDescriptor writeMethodDescriptor;
    protected final FieldDescriptor fieldDescriptor;
    protected Class type;
    protected Getter[] getters;
    protected Setter[] setters;

    public PropertyDescriptor(ClassDescriptor classDescriptor, String propertyName, FieldDescriptor fieldDescriptor) {
        super(classDescriptor, false);
        this.name = propertyName;
        this.readMethodDescriptor = null;
        this.writeMethodDescriptor = null;
        this.fieldDescriptor = fieldDescriptor;
    }

    public PropertyDescriptor(ClassDescriptor classDescriptor, String propertyName, MethodDescriptor readMethod, MethodDescriptor writeMethod) {
        super(classDescriptor, (readMethod == null || readMethod.isPublic()) & (writeMethod == null || writeMethod.isPublic()));
        this.name = propertyName;
        this.readMethodDescriptor = readMethod;
        this.writeMethodDescriptor = writeMethod;
        this.fieldDescriptor = classDescriptor.isExtendedProperties() ? this.findField(propertyName) : null;
    }

    protected FieldDescriptor findField(String fieldName) {
        String prefix = this.classDescriptor.getPropertyFieldPrefix();
        if (prefix != null) {
            fieldName = prefix + fieldName;
        }
        return this.classDescriptor.getFieldDescriptor(fieldName, true);
    }

    public String getName() {
        return this.name;
    }

    public MethodDescriptor getReadMethodDescriptor() {
        return this.readMethodDescriptor;
    }

    public MethodDescriptor getWriteMethodDescriptor() {
        return this.writeMethodDescriptor;
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    public boolean isFieldOnlyDescriptor() {
        return this.readMethodDescriptor == null && this.writeMethodDescriptor == null;
    }

    public Class getType() {
        if (this.type == null) {
            if (this.readMethodDescriptor != null) {
                this.type = this.readMethodDescriptor.getMethod().getReturnType();
            } else if (this.writeMethodDescriptor != null) {
                this.type = this.writeMethodDescriptor.getMethod().getParameterTypes()[0];
            } else if (this.fieldDescriptor != null) {
                this.type = this.fieldDescriptor.getField().getType();
            }
        }
        return this.type;
    }

    public Getter getGetter(boolean declared) {
        if (this.getters == null) {
            this.getters = new Getter[]{this.createGetter(false), this.createGetter(true)};
        }
        return this.getters[declared ? 1 : 0];
    }

    protected Getter createGetter(boolean declared) {
        if (this.readMethodDescriptor != null && this.readMethodDescriptor.matchDeclared(declared)) {
            return this.readMethodDescriptor;
        }
        if (this.fieldDescriptor != null && this.fieldDescriptor.matchDeclared(declared)) {
            return this.fieldDescriptor;
        }
        return null;
    }

    public Setter getSetter(boolean declared) {
        if (this.setters == null) {
            this.setters = new Setter[]{this.createSetter(false), this.createSetter(true)};
        }
        return this.setters[declared ? 1 : 0];
    }

    protected Setter createSetter(boolean declared) {
        if (this.writeMethodDescriptor != null && this.writeMethodDescriptor.matchDeclared(declared)) {
            return this.writeMethodDescriptor;
        }
        if (this.fieldDescriptor != null && this.fieldDescriptor.matchDeclared(declared)) {
            return this.fieldDescriptor;
        }
        return null;
    }
}

