/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import jodd.introspector.ClassDescriptor;
import jodd.util.ReflectUtil;

public class FieldDescriptor {
    protected final ClassDescriptor classDescriptor;
    protected final Field field;
    protected final Type type;
    protected final Class rawType;
    protected final Class rawComponentType;
    protected final Class rawKeyComponentType;

    public FieldDescriptor(ClassDescriptor classDescriptor, Field field) {
        this.classDescriptor = classDescriptor;
        this.field = field;
        this.type = field.getGenericType();
        this.rawType = ReflectUtil.getRawType((Type)this.type, (Class)classDescriptor.getType());
        this.rawComponentType = ReflectUtil.getComponentType((Type)this.type, (Class)classDescriptor.getType());
        this.rawKeyComponentType = ReflectUtil.getComponentType((Type)this.type, (Class)classDescriptor.getType(), (int)0);
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public Field getField() {
        return this.field;
    }

    public Class getRawType() {
        return this.rawType;
    }

    public Class getRawComponentType() {
        return this.rawComponentType;
    }

    public Class getRawKeyComponentType() {
        return this.rawKeyComponentType;
    }

    public Class resolveRawComponentType(int index) {
        return ReflectUtil.getComponentType((Type)this.type, (Class)this.classDescriptor.getType(), (int)index);
    }
}

