/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jodd.cache.TypeCache;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.PropertyDescriptor;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ScopeResolver;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.Out;
import jodd.madvoc.meta.Scope;
import jodd.madvoc.scope.MadvocScope;
import jodd.petite.meta.PetiteInject;
import jodd.util.StringUtil;

public class ScopeDataInspector {
    @PetiteInject
    protected ScopeResolver scopeResolver;
    private final ScopeData NO_SCOPE_DATA;
    private final TypeCache<ScopeData> scopeDataTypeCache = TypeCache.createDefault();

    public ScopeDataInspector() {
        this.NO_SCOPE_DATA = new ScopeData(this, null, null);
    }

    public Class<? extends Annotation> detectAnnotationType(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof In) {
                return annotation.annotationType();
            }
            if (!(annotation instanceof Out)) continue;
            return annotation.annotationType();
        }
        return null;
    }

    public ScopeData inspectMethodParameterScopes(String name, Class type, Annotation[] annotations) {
        InjectionPoint scopeDataOut;
        InjectionPoint scopeDataIn;
        In in = null;
        Out out = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof In) {
                in = (In)annotation;
                continue;
            }
            if (!(annotation instanceof Out)) continue;
            out = (Out)annotation;
        }
        Class<? extends MadvocScope> scope = this.resolveScopeClassFromAnnotations(annotations);
        int count = 0;
        InjectionPoint[] ins = null;
        InjectionPoint[] outs = null;
        if (in != null && (scopeDataIn = this.buildInjectionPoint(in.value(), in.defaultValue(), name, type, scope)) != null) {
            ++count;
            ins = new InjectionPoint[]{scopeDataIn};
        }
        if (out != null && (scopeDataOut = this.buildInjectionPoint(out.value(), null, name, type, scope)) != null) {
            ++count;
            outs = new InjectionPoint[]{scopeDataOut};
        }
        if (count == 0) {
            return this.NO_SCOPE_DATA;
        }
        return new ScopeData(this, ins, outs);
    }

    protected Class<? extends MadvocScope> resolveScopeClassFromAnnotations(Annotation[] annotations) {
        Class<? extends MadvocScope> scope = null;
        for (Annotation annotation : annotations) {
            Annotation[] annotationAnnotations;
            if (annotation instanceof Scope) {
                if (scope != null) {
                    throw new MadvocException("Scope already defined: " + scope);
                }
                scope = ((Scope)annotation).value();
                continue;
            }
            Class<? extends MadvocScope> annotationScope = null;
            for (Annotation innerAnnotation : annotationAnnotations = annotation.annotationType().getAnnotations()) {
                if (!(innerAnnotation instanceof Scope)) continue;
                annotationScope = ((Scope)innerAnnotation).value();
            }
            if (annotationScope == null) continue;
            if (scope == null) {
                scope = annotationScope;
                continue;
            }
            throw new MadvocException("Scope already defined: " + scope);
        }
        return scope;
    }

    protected InjectionPoint buildInjectionPoint(String annotationValue, String defaultValue, String propertyName, Class propertyType, Class<? extends MadvocScope> scope) {
        String targetName;
        String name;
        String value = annotationValue.trim();
        if (StringUtil.isNotBlank(value)) {
            name = value;
            targetName = propertyName;
        } else {
            name = propertyName;
            targetName = null;
        }
        return new InjectionPoint(propertyType, name, targetName, this.scopeResolver.defaultOrScopeType(scope), defaultValue);
    }

    public ScopeData inspectClassScopesWithCache(Class actionClass) {
        return this.scopeDataTypeCache.get(actionClass, this::inspectClassScopes);
    }

    public ScopeData inspectClassScopes(Class actionClass) {
        ClassDescriptor cd = ClassIntrospector.get().lookup(actionClass);
        PropertyDescriptor[] allProperties = cd.getAllPropertyDescriptors();
        ArrayList<InjectionPoint> listIn = new ArrayList<InjectionPoint>(allProperties.length);
        ArrayList<InjectionPoint> listOut = new ArrayList<InjectionPoint>(allProperties.length);
        for (PropertyDescriptor pd : allProperties) {
            InjectionPoint oi;
            InjectionPoint ii;
            Method method;
            Class<? extends MadvocScope> scope = null;
            In in = null;
            Out out = null;
            if (pd.getFieldDescriptor() != null) {
                Field field = pd.getFieldDescriptor().getField();
                in = field.getAnnotation(In.class);
                out = field.getAnnotation(Out.class);
                scope = this.resolveScopeClassFromAnnotations(field.getAnnotations());
            }
            if (pd.getWriteMethodDescriptor() != null) {
                method = pd.getWriteMethodDescriptor().getMethod();
                if (in == null) {
                    in = method.getAnnotation(In.class);
                }
                if (out == null) {
                    out = method.getAnnotation(Out.class);
                }
                if (scope == null) {
                    scope = this.resolveScopeClassFromAnnotations(method.getAnnotations());
                }
            }
            if (pd.getReadMethodDescriptor() != null) {
                method = pd.getReadMethodDescriptor().getMethod();
                if (in == null) {
                    in = method.getAnnotation(In.class);
                }
                if (out == null) {
                    out = method.getAnnotation(Out.class);
                }
                if (scope == null) {
                    scope = this.resolveScopeClassFromAnnotations(method.getAnnotations());
                }
            }
            InjectionPoint injectionPoint = ii = in == null ? null : this.buildInjectionPoint(in.value(), in.defaultValue(), pd.getName(), pd.getType(), scope);
            if (ii != null) {
                listIn.add(ii);
            }
            InjectionPoint injectionPoint2 = oi = out == null ? null : this.buildInjectionPoint(out.value(), null, pd.getName(), pd.getType(), scope);
            if (oi == null) continue;
            listOut.add(oi);
        }
        if (listIn.isEmpty() && listOut.isEmpty()) {
            return this.NO_SCOPE_DATA;
        }
        InjectionPoint[] in = null;
        InjectionPoint[] out = null;
        if (!listIn.isEmpty()) {
            in = listIn.toArray(new InjectionPoint[0]);
        }
        if (!listOut.isEmpty()) {
            out = listOut.toArray(new InjectionPoint[0]);
        }
        return new ScopeData(this, in, out);
    }
}

