/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.Map;
import jodd.http.HttpMultiMap;
import jodd.net.URLCoder;
import jodd.net.URLDecoder;
import jodd.util.StringBand;
import jodd.util.StringUtil;

public class HttpUtil {
    public static String buildQuery(HttpMultiMap<?> queryMap, String encoding) {
        if (queryMap.isEmpty()) {
            return "";
        }
        int queryMapSize = queryMap.size();
        StringBand query = new StringBand(queryMapSize * 4);
        int count = 0;
        for (Map.Entry<String, ?> entry : queryMap) {
            String key = entry.getKey();
            key = URLCoder.encodeQueryParam(key, encoding);
            Object value = entry.getValue();
            if (value == null) {
                if (count != 0) {
                    query.append('&');
                }
                query.append(key);
                ++count;
                continue;
            }
            if (count != 0) {
                query.append('&');
            }
            query.append(key);
            ++count;
            query.append('=');
            String valueString = URLCoder.encodeQueryParam(value.toString(), encoding);
            query.append(valueString);
        }
        return query.toString();
    }

    public static HttpMultiMap<String> parseQuery(String query, boolean decode) {
        String paramAndValue;
        HttpMultiMap<String> queryMap = HttpMultiMap.newCaseInsensitiveMap();
        if (StringUtil.isBlank(query)) {
            return queryMap;
        }
        for (int lastNdx = 0; lastNdx < query.length(); lastNdx += paramAndValue.length() + 1) {
            int ndx = query.indexOf(38, lastNdx);
            if (ndx == -1) {
                ndx = query.length();
            }
            if ((ndx = (paramAndValue = query.substring(lastNdx, ndx)).indexOf(61)) == -1) {
                queryMap.add(paramAndValue, null);
                continue;
            }
            String name = paramAndValue.substring(0, ndx);
            if (decode) {
                name = URLDecoder.decodeQuery(name);
            }
            String value = paramAndValue.substring(ndx + 1);
            if (decode) {
                value = URLDecoder.decodeQuery(value);
            }
            queryMap.add(name, value);
        }
        return queryMap;
    }

    public static String prepareHeaderParameterName(String headerName) {
        if (headerName.equals("etag")) {
            return "ETag";
        }
        if (headerName.equals("www-authenticate")) {
            return "WWW-Authenticate";
        }
        char[] name = headerName.toCharArray();
        boolean capitalize = true;
        for (int i = 0; i < name.length; ++i) {
            char c = name[i];
            if (c == '-') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                name[i] = Character.toUpperCase(c);
                capitalize = false;
                continue;
            }
            name[i] = Character.toLowerCase(c);
        }
        return new String(name);
    }

    public static String extractMediaType(String contentType) {
        int index = contentType.indexOf(59);
        if (index == -1) {
            return contentType;
        }
        return contentType.substring(0, index);
    }

    public static String extractContentTypeCharset(String contentType) {
        return HttpUtil.extractHeaderParameter(contentType, "charset", ';');
    }

    public static String extractKeepAliveTimeout(String keepAlive) {
        return HttpUtil.extractHeaderParameter(keepAlive, "timeout", ',');
    }

    public static String extractKeepAliveMax(String keepAlive) {
        return HttpUtil.extractHeaderParameter(keepAlive, "max", ',');
    }

    public static String extractHeaderParameter(String header, String parameter, char separator) {
        int eqNdx;
        int index = 0;
        while (true) {
            if ((index = header.indexOf(separator, index)) == -1) {
                return null;
            }
            ++index;
            while (index < header.length() && header.charAt(index) == ' ') {
                ++index;
            }
            eqNdx = header.indexOf(61, index);
            if (eqNdx == -1) {
                return null;
            }
            String paramName = header.substring(index, eqNdx);
            ++eqNdx;
            if (paramName.equalsIgnoreCase(parameter)) break;
            index = eqNdx;
        }
        int endIndex = header.indexOf(59, eqNdx);
        if (endIndex == -1) {
            return header.substring(eqNdx);
        }
        return header.substring(eqNdx, endIndex);
    }
}

