/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import jodd.db.DbDetector;
import jodd.db.DbQueryConfig;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.db.ThreadDbSessionProvider;
import jodd.db.connection.ConnectionProvider;
import jodd.db.oom.DbEntityManager;
import jodd.db.oom.DbOomConfig;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.sqlgen.DbEntitySql;
import jodd.db.oom.sqlgen.DbSqlBuilder;
import jodd.db.pool.CoreConnectionPool;
import jodd.db.querymap.EmptyQueryMap;
import jodd.db.querymap.QueryMap;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

public class DbOom {
    private static final Logger log = LoggerFactory.getLogger(DbOom.class);
    private static DbOom defaultDbOom;
    private final ConnectionProvider connectionProvider;
    private final DbSessionProvider dbSessionProvider;
    private final QueryMap queryMap;
    private final DbQueryConfig dbQueryConfig;
    private final DbOomConfig dbOomConfig;
    private final DbEntityManager dbEntityManager;
    private final DbEntitySql dbEntitySql;

    public static DbOom get() {
        if (defaultDbOom == null) {
            throw new DbSqlException("No default DbOom available. Use DbOom to create one.\nIf more then one DbOom is in use, there is no default instance.");
        }
        return defaultDbOom;
    }

    public static Builder create() {
        return new Builder();
    }

    public DbOom(ConnectionProvider connectionProvider, DbSessionProvider dbSessionProvider, QueryMap queryMap) {
        this.connectionProvider = connectionProvider;
        this.dbSessionProvider = dbSessionProvider;
        this.queryMap = queryMap;
        this.dbOomConfig = new DbOomConfig();
        this.dbQueryConfig = new DbQueryConfig();
        this.dbEntityManager = new DbEntityManager(this.dbOomConfig);
        this.dbEntitySql = new DbEntitySql(this);
        if (defaultDbOom == null) {
            log.info("Default DbOom is created.");
            defaultDbOom = this;
        } else {
            log.warn("Multiple DbOom detected.");
            defaultDbOom = null;
        }
    }

    public DbOom connect() {
        this.connectionProvider.init();
        DbDetector dbDetector = new DbDetector();
        dbDetector.detectDatabaseAndConfigureDbOom(this.connectionProvider, this.dbOomConfig);
        return this;
    }

    public void shutdown() {
        if (defaultDbOom == this) {
            defaultDbOom = null;
        }
        this.connectionProvider.close();
    }

    public DbOomConfig config() {
        return this.dbOomConfig;
    }

    public DbQueryConfig queryConfig() {
        return this.dbQueryConfig;
    }

    public DbEntityManager entityManager() {
        return this.dbEntityManager;
    }

    public DbSessionProvider sessionProvider() {
        return this.dbSessionProvider;
    }

    public ConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    public QueryMap queryMap() {
        return this.queryMap;
    }

    public DbEntitySql entities() {
        return this.dbEntitySql;
    }

    public DbSqlBuilder sql(String sql) {
        return new DbSqlBuilder(this, sql);
    }

    public DbSqlBuilder sql() {
        return new DbSqlBuilder(this);
    }

    public DbOomQuery query(String sql) {
        return new DbOomQuery(this, this.sessionProvider().getDbSession(), sql);
    }

    public DbOomQuery query(DbSqlGenerator sql) {
        return new DbOomQuery(this, this.sessionProvider().getDbSession(), sql);
    }

    public static class Builder {
        private ConnectionProvider connectionProvider;
        private DbSessionProvider dbSessionProvider;
        private QueryMap queryMap;

        public Builder withSessionProvider(DbSessionProvider sessionProvider) {
            this.dbSessionProvider = sessionProvider;
            return this;
        }

        public Builder withConnectionProvider(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
            return this;
        }

        public Builder withQueryMap(QueryMap queryMap) {
            this.queryMap = queryMap;
            return this;
        }

        public DbOom get() {
            if (this.connectionProvider == null) {
                this.connectionProvider = new CoreConnectionPool();
            }
            if (this.dbSessionProvider == null) {
                this.dbSessionProvider = new ThreadDbSessionProvider();
            }
            if (this.queryMap == null) {
                this.queryMap = new EmptyQueryMap();
            }
            return new DbOom(this.connectionProvider, this.dbSessionProvider, this.queryMap);
        }
    }
}

