/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.util.ArrayList;
import java.util.List;
import jodd.petite.BeanData;
import jodd.petite.DestroyMethodPoint;
import jodd.petite.PetiteUtil;
import jodd.petite.scope.Scope;

public abstract class ShutdownAwareScope
implements Scope {
    protected List<BeanData> destroyableBeans;

    protected boolean isBeanDestroyable(BeanData beanData) {
        DestroyMethodPoint[] dmp = beanData.getBeanDefinition().getDestroyMethodPoints();
        return dmp != null && dmp.length != 0;
    }

    protected void registerDestroyableBeans(BeanData beanData) {
        if (!this.isBeanDestroyable(beanData)) {
            return;
        }
        if (this.destroyableBeans == null) {
            this.destroyableBeans = new ArrayList<BeanData>();
        }
        this.destroyableBeans.add(beanData);
    }

    protected int totalRegisteredDestroyableBeans() {
        if (this.destroyableBeans == null) {
            return 0;
        }
        return this.destroyableBeans.size();
    }

    protected void destroyBean(BeanData beanData) {
        if (this.destroyableBeans == null) {
            return;
        }
        if (!this.isBeanDestroyable(beanData)) {
            return;
        }
        if (this.destroyableBeans.remove(beanData)) {
            PetiteUtil.callDestroyMethods(beanData);
        }
    }

    @Override
    public void shutdown() {
        if (this.destroyableBeans == null) {
            return;
        }
        for (BeanData destroyableBean : this.destroyableBeans) {
            PetiteUtil.callDestroyMethods(destroyableBean);
        }
        this.destroyableBeans.clear();
    }
}

