/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jodd.core.JoddCore;
import jodd.util.StringUtil;

public class EmailAddress {
    public static final EmailAddress[] EMPTY_ARRAY = new EmailAddress[0];
    private final String email;
    private final String personalName;

    public EmailAddress(String personalName, String email) {
        this.email = email;
        this.personalName = personalName;
    }

    public EmailAddress(String address) {
        address = address.trim();
        if (!StringUtil.endsWithChar(address, '>')) {
            this.email = address;
            this.personalName = null;
            return;
        }
        int ndx = address.lastIndexOf(60);
        if (ndx == -1) {
            this.email = address;
            this.personalName = null;
            return;
        }
        this.email = address.substring(ndx + 1, address.length() - 1);
        this.personalName = address.substring(0, ndx).trim();
    }

    public EmailAddress(InternetAddress internetAddress) {
        this.personalName = internetAddress.getPersonal();
        this.email = internetAddress.getAddress();
    }

    public EmailAddress(Address address) {
        this(address.toString());
    }

    public String getEmail() {
        return this.email;
    }

    public String getPersonalName() {
        return this.personalName;
    }

    public InternetAddress toInternetAddress() throws AddressException {
        try {
            return new InternetAddress(this.email, this.personalName, JoddCore.encoding);
        }
        catch (UnsupportedEncodingException ueex) {
            throw new AddressException(ueex.toString());
        }
    }

    public String toString() {
        if (this.personalName == null) {
            return this.email;
        }
        return this.personalName + " <" + this.email + '>';
    }

    public static EmailAddress[] createFrom(Address ... addresses) {
        if (addresses == null) {
            return null;
        }
        if (addresses.length == 0) {
            return null;
        }
        EmailAddress[] res = new EmailAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            res[i] = new EmailAddress(addresses[i]);
        }
        return res;
    }

    public static EmailAddress[] createFrom(String ... addresses) {
        if (addresses == null) {
            return null;
        }
        if (addresses.length == 0) {
            return null;
        }
        EmailAddress[] res = new EmailAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            res[i] = new EmailAddress(addresses[i]);
        }
        return res;
    }
}

