/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.path;

import java.lang.reflect.Method;
import jodd.madvoc.ActionDef;
import jodd.madvoc.ActionNames;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.meta.In;
import jodd.madvoc.path.BaseNamingStrategy;
import jodd.util.CharUtil;

public class RestResourcePath
extends BaseNamingStrategy {
    @In(scope=ScopeType.CONTEXT)
    protected MadvocConfig madvocConfig;

    @Override
    public ActionDef buildActionDef(Class actionClass, Method actionMethod, ActionNames actionNames) {
        String packageActionPath = actionNames.getPackageActionPath();
        String classActionPath = actionNames.getClassActionPath();
        String methodActionPath = actionNames.getMethodActionPath();
        String httpMethod = actionNames.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = this.resolveHttpMethodFromMethodName(actionMethod.getName());
        }
        String actionPath = classActionPath;
        String resultPath = classActionPath;
        if (this.isAbsolutePath(methodActionPath)) {
            return this.createActionDef(methodActionPath, httpMethod, methodActionPath, actionNames);
        }
        if (methodActionPath != null) {
            if (httpMethod == null && methodActionPath.startsWith(this.madvocConfig.getPathMacroSeparators()[0])) {
                methodActionPath = actionMethod.getName() + "/" + methodActionPath;
            }
            if (!classActionPath.endsWith("/")) {
                actionPath = actionPath + "/";
                resultPath = resultPath + "/";
            }
            actionPath = actionPath + methodActionPath;
            resultPath = httpMethod != null ? resultPath + httpMethod.toLowerCase() : resultPath + actionNames.getMethodName();
        }
        if (this.isAbsolutePath(actionPath)) {
            return this.createActionDef(actionPath, httpMethod, resultPath, actionNames);
        }
        if (packageActionPath != null) {
            actionPath = packageActionPath + actionPath;
            resultPath = packageActionPath + resultPath;
        } else {
            actionPath = "/" + actionPath;
            resultPath = "/" + resultPath;
        }
        return this.createActionDef(actionPath, httpMethod, resultPath, actionNames);
    }

    protected String resolveHttpMethodFromMethodName(String methodName) {
        int i;
        for (i = 0; i < methodName.length() && !CharUtil.isUppercaseAlpha(methodName.charAt(i)); ++i) {
        }
        String name = methodName.substring(0, i).toUpperCase();
        if (name.equals("CONNECT")) {
            return "CONNECT";
        }
        if (name.equals("DELETE")) {
            return "DELETE";
        }
        if (name.equals("GET")) {
            return "GET";
        }
        if (name.equals("HEAD")) {
            return "HEAD";
        }
        if (name.equals("OPTIONS")) {
            return "OPTIONS";
        }
        if (name.equals("PATCH")) {
            return "PATCH";
        }
        if (name.equalsIgnoreCase("POST")) {
            return "POST";
        }
        if (name.equals("PUT")) {
            return "PUT";
        }
        if (name.equals("TRACE")) {
            return "TRACE";
        }
        return null;
    }
}

