/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.exception.ExceptionUtil;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionWrapper;
import jodd.madvoc.BaseActionWrapper;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.injector.Target;
import jodd.madvoc.meta.Out;
import jodd.madvoc.result.Result;

public class ActionRequest {
    protected final MadvocController madvocController;
    protected final ActionConfig actionConfig;
    protected final String actionPath;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected Result result;
    protected final Target[] targets;
    protected final ActionWrapper[] executionArray;
    protected int executionIndex;
    protected Object action;
    protected Object actionResult;
    protected String nextActionPath;
    protected ActionRequest previousActionRequest;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.servletResponse = response;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    public Object getAction() {
        return this.action;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public String getNextActionPath() {
        return this.nextActionPath;
    }

    public void setNextActionPath(String nextActionPath) {
        this.nextActionPath = nextActionPath;
    }

    public ActionRequest getPreviousActionRequest() {
        return this.previousActionRequest;
    }

    public void setPreviousActionRequest(ActionRequest previousActionRequest) {
        this.previousActionRequest = previousActionRequest;
    }

    public Result getResult() {
        return this.result;
    }

    public Target[] getTargets() {
        return this.targets;
    }

    public Object getActionResult() {
        return this.actionResult;
    }

    public void setActionResult(Object actionResult) {
        this.actionResult = actionResult;
    }

    public ActionRequest(MadvocController madvocController, String actionPath, ActionConfig actionConfig, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.madvocController = madvocController;
        this.actionPath = actionPath;
        this.actionConfig = actionConfig;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.action = action;
        this.result = this.findResult();
        this.targets = this.makeTargets();
        this.executionIndex = 0;
        this.executionArray = this.createExecutionArray();
    }

    protected ActionWrapper[] createExecutionArray() {
        int totalInterceptors = this.actionConfig.interceptors != null ? this.actionConfig.interceptors.length : 0;
        int totalFilters = this.actionConfig.filters != null ? this.actionConfig.filters.length : 0;
        ActionWrapper[] executionArray = new ActionWrapper[totalFilters + 1 + totalInterceptors + 1];
        int index = 0;
        if (totalFilters > 0) {
            System.arraycopy(this.actionConfig.filters, 0, executionArray, index, totalFilters);
            index += totalFilters;
        }
        executionArray[index++] = new BaseActionWrapper(){

            @Override
            public Object invoke(ActionRequest actionRequest) throws Exception {
                Object actionResult = actionRequest.invoke();
                ActionRequest.this.madvocController.render(ActionRequest.this, actionResult);
                return actionResult;
            }
        };
        if (totalInterceptors > 0) {
            System.arraycopy(this.actionConfig.interceptors, 0, executionArray, index, totalInterceptors);
            index += totalInterceptors;
        }
        executionArray[index] = new BaseActionWrapper(){

            @Override
            public Object invoke(ActionRequest actionRequest) throws Exception {
                ActionRequest.this.actionResult = ActionRequest.this.invokeActionMethod();
                return ActionRequest.this.actionResult;
            }
        };
        return executionArray;
    }

    protected Result findResult() {
        Field resultField = this.actionConfig.resultField;
        if (resultField != null) {
            try {
                Result result = (Result)resultField.get(this.action);
                if (result == null) {
                    result = (Result)resultField.getType().newInstance();
                    resultField.set(this.action, result);
                }
                return result;
            }
            catch (Exception ignore) {
                return null;
            }
        }
        return null;
    }

    protected Target[] makeTargets() {
        if (!this.actionConfig.hasArguments) {
            return new Target[]{new Target(this.action)};
        }
        ActionConfig.MethodParam[] methodParams = this.actionConfig.getMethodParams();
        Target[] target = new Target[methodParams.length + 1];
        target[0] = new Target(this.action);
        for (int i = 0; i < methodParams.length; ++i) {
            ActionConfig.MethodParam mp = methodParams[i];
            Class type = mp.getType();
            Target t = mp.getAnnotationType() == null ? new Target(this.createActionMethodArgument(type)) : (mp.getAnnotationType() == Out.class ? new Target(this.createActionMethodArgument(type), type) : new Target(type){

                @Override
                protected void createValueInstance() {
                    this.value = ActionRequest.this.createActionMethodArgument(this.type);
                }
            });
            target[i + 1] = t;
        }
        return target;
    }

    protected Object createActionMethodArgument(Class type) {
        try {
            if (type.getEnclosingClass() == null || Modifier.isStatic(type.getModifiers())) {
                Constructor ctor = type.getDeclaredConstructor(null);
                ctor.setAccessible(true);
                return ctor.newInstance(new Object[0]);
            }
            Constructor ctor = type.getDeclaredConstructor(type.getDeclaringClass());
            ctor.setAccessible(true);
            return ctor.newInstance(this.action);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    }

    public Object invoke() throws Exception {
        return this.executionArray[this.executionIndex++].invoke(this);
    }

    protected Object invokeActionMethod() throws Exception {
        Object[] params = this.extractParametersFromTargets();
        try {
            return this.actionConfig.actionClassMethod.invoke(this.action, params);
        }
        catch (InvocationTargetException itex) {
            throw ExceptionUtil.extractTargetException(itex);
        }
    }

    protected Object[] extractParametersFromTargets() {
        if (this.targets == null) {
            return null;
        }
        Object[] values = new Object[this.targets.length - 1];
        for (int i = 1; i < this.targets.length; ++i) {
            values[i - 1] = this.targets[i].getValue();
        }
        return values;
    }
}

