/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.util.Arrays;
import jodd.json.Path;
import jodd.util.StringUtil;

public class PathQuery {
    protected final String[] expression;
    protected final boolean wildcard;
    protected final boolean included;

    public PathQuery(String expression, boolean included) {
        this.expression = StringUtil.splitc(expression, '.');
        this.wildcard = expression.indexOf(42) >= 0;
        this.included = included;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < this.expression.length; ++i) {
            if (i > 0) {
                builder.append('.');
            }
            builder.append(this.expression[i]);
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean matches(Path path) {
        int exprNdx = 0;
        int pathNdx = 0;
        int pathLen = path.length();
        int exprLen = this.expression.length;
        while (pathNdx < pathLen) {
            String current = path.get(pathNdx);
            if (exprNdx < exprLen && this.expression[exprNdx].equals("*")) {
                ++exprNdx;
                continue;
            }
            if (exprNdx < exprLen && this.expression[exprNdx].equals(current)) {
                ++pathNdx;
                ++exprNdx;
                continue;
            }
            if (exprNdx - 1 >= 0 && this.expression[exprNdx - 1].equals("*")) {
                ++pathNdx;
                continue;
            }
            return false;
        }
        if (exprNdx > 0 && this.expression[exprNdx - 1].equals("*")) {
            return pathNdx >= pathLen && exprNdx >= exprLen;
        }
        return pathLen != 0 && pathNdx >= pathLen && (this.included || exprNdx >= exprLen);
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathQuery pathQuery = (PathQuery)o;
        if (this.included != pathQuery.included) {
            return false;
        }
        return Arrays.equals(this.expression, pathQuery.expression);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.expression);
        result = 31 * result + (this.included ? 1 : 0);
        return result;
    }
}

