/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import jodd.db.DbSqlException;
import jodd.db.connection.ConnectionProvider;

public class DriverManagerConnectionProvider
implements ConnectionProvider {
    private String url;
    private String username;
    private String password;
    private String driverClass;
    private Integer isolation;
    private Boolean autoCommit;

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void setIsolation(Integer isolation) {
        this.isolation = isolation;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public DriverManagerConnectionProvider(String driverClass, String url, String username, String password) {
        this.driverClass = driverClass;
        this.password = password;
        this.username = username;
        this.url = url;
    }

    public DriverManagerConnectionProvider(String driverClass, String url) {
        this.driverClass = driverClass;
        this.url = url;
    }

    @Override
    public synchronized void init() {
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException cnfex) {
            throw new DbSqlException("JDBC driver not found: " + this.driverClass, cnfex);
        }
    }

    @Override
    public Connection getConnection() {
        Connection conn;
        try {
            conn = this.username != null ? DriverManager.getConnection(this.url, this.username, this.password) : DriverManager.getConnection(this.url);
            if (this.isolation != null) {
                conn.setTransactionIsolation(this.isolation);
            }
            if (this.autoCommit != null) {
                conn.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException("Connection not found", sex);
        }
        return conn;
    }

    @Override
    public void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
    }
}

