/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.bean.BeanUtil;
import jodd.bean.BeanUtilUtil;
import jodd.introspector.Getter;
import jodd.introspector.Setter;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;

public class BeanUtilBean
extends BeanUtilUtil
implements BeanUtil {
    private static final char[] INDEX_CHARS = new char[]{'.', '['};

    public BeanUtilBean declared(boolean declared) {
        this.isDeclared = declared;
        return this;
    }

    public BeanUtilBean forced(boolean forced) {
        this.isForced = forced;
        return this;
    }

    public BeanUtilBean silent(boolean silent) {
        this.isSilent = silent;
        return this;
    }

    protected void resolveNestedProperties(BeanProperty bp) {
        int dotNdx;
        String name = bp.name;
        while ((dotNdx = this.indexOfDot(name)) != -1) {
            bp.last = false;
            bp.setName(name.substring(0, dotNdx));
            bp.setBean(this.getIndexProperty(bp));
            name = name.substring(dotNdx + 1);
        }
        bp.last = true;
        bp.setName(name);
    }

    protected boolean resolveExistingNestedProperties(BeanProperty bp) {
        int dotNdx;
        String name = bp.name;
        while ((dotNdx = this.indexOfDot(name)) != -1) {
            bp.last = false;
            bp.setName(name.substring(0, dotNdx));
            String temp = bp.name;
            if (!this.hasIndexProperty(bp)) {
                return false;
            }
            bp.setName(temp);
            bp.setBean(this.getIndexProperty(bp));
            name = name.substring(dotNdx + 1);
        }
        bp.last = true;
        bp.setName(name);
        return true;
    }

    @Override
    public boolean hasSimpleProperty(Object bean, String property) {
        return this.hasSimpleProperty(new BeanProperty(this, bean, property));
    }

    protected boolean hasSimpleProperty(BeanProperty bp) {
        Map map;
        if (bp.bean == null) {
            return false;
        }
        Getter getter = bp.getGetter(this.isDeclared);
        if (getter != null) {
            return true;
        }
        return bp.isMap() && (map = (Map)bp.bean).containsKey(bp.name);
    }

    @Override
    public <T> T getSimpleProperty(Object bean, String property) {
        return (T)this.getSimpleProperty(new BeanProperty(this, bean, property));
    }

    protected Object getSimpleProperty(BeanProperty bp) {
        if (bp.name.length() == 0) {
            if (bp.indexString != null) {
                return bp.bean;
            }
            throw new BeanException("Invalid property", bp);
        }
        Getter getter = bp.getGetter(this.isDeclared);
        if (getter != null) {
            Object result;
            try {
                result = getter.invokeGetter(bp.bean);
            }
            catch (Exception ex) {
                if (this.isSilent) {
                    return null;
                }
                throw new BeanException("Getter failed: " + getter, ex);
            }
            if (result == null && this.isForced) {
                result = this.createBeanProperty(bp);
            }
            return result;
        }
        if (bp.isMap()) {
            Map map = (Map)bp.bean;
            Object key = this.convertIndexToMapKey(getter, bp.name);
            if (!map.containsKey(key)) {
                if (!this.isForced) {
                    if (this.isSilent) {
                        return null;
                    }
                    throw new BeanException("Map key not found: " + bp.name, bp);
                }
                HashMap value = new HashMap();
                map.put(key, value);
                return value;
            }
            return map.get(key);
        }
        if (this.isSilent) {
            return null;
        }
        throw new BeanException("Simple property not found: " + bp.name, bp);
    }

    @Override
    public void setSimpleProperty(Object bean, String property, Object value) {
        this.setSimpleProperty(new BeanProperty(this, bean, property), value);
    }

    protected void setSimpleProperty(BeanProperty bp, Object value) {
        Setter setter = bp.getSetter(this.isDeclared);
        if (setter != null) {
            this.invokeSetter(setter, bp, value);
            return;
        }
        if (bp.isMap()) {
            ((Map)bp.bean).put(bp.name, value);
            return;
        }
        if (this.isSilent) {
            return;
        }
        throw new BeanException("Simple property not found: " + bp.name, bp);
    }

    protected boolean hasIndexProperty(BeanProperty bp) {
        if (bp.bean == null) {
            return false;
        }
        String indexString = this.extractIndex(bp);
        if (indexString == null) {
            return this.hasSimpleProperty(bp);
        }
        Object resultBean = this.getSimpleProperty(bp);
        if (resultBean == null) {
            return false;
        }
        if (resultBean.getClass().isArray()) {
            int index = this.parseInt(indexString, bp);
            return index >= 0 && index < Array.getLength(resultBean);
        }
        if (resultBean instanceof List) {
            int index = this.parseInt(indexString, bp);
            return index >= 0 && index < ((List)resultBean).size();
        }
        if (resultBean instanceof Map) {
            return ((Map)resultBean).containsKey(indexString);
        }
        return false;
    }

    @Override
    public <T> T getIndexProperty(Object bean, String property, int index) {
        BeanProperty bp = new BeanProperty(this, bean, property);
        bp.indexString = bp.index = String.valueOf(index);
        Object value = this._getIndexProperty(bp);
        bp.indexString = null;
        return (T)value;
    }

    protected Object getIndexProperty(BeanProperty bp) {
        bp.indexString = this.extractIndex(bp);
        Object value = this._getIndexProperty(bp);
        bp.indexString = null;
        return value;
    }

    private Object _getIndexProperty(BeanProperty bp) {
        Object resultBean = this.getSimpleProperty(bp);
        Getter getter = bp.getGetter(this.isDeclared);
        if (bp.indexString == null) {
            return resultBean;
        }
        if (resultBean == null) {
            if (this.isSilent) {
                return null;
            }
            throw new BeanException("Index property is null: " + bp.name, bp);
        }
        if (resultBean.getClass().isArray()) {
            int index = this.parseInt(bp.indexString, bp);
            if (this.isForced) {
                return this.arrayForcedGet(bp, resultBean, index);
            }
            return Array.get(resultBean, index);
        }
        if (resultBean instanceof List) {
            Object value;
            int index = this.parseInt(bp.indexString, bp);
            List list = (List)resultBean;
            if (!this.isForced) {
                return list.get(index);
            }
            if (!bp.last) {
                this.ensureListSize(list, index);
            }
            if ((value = list.get(index)) == null) {
                Class<Map> listComponentType = this.extractGenericComponentType(getter);
                if (listComponentType == Object.class) {
                    listComponentType = Map.class;
                }
                try {
                    value = ClassUtil.newInstance(listComponentType);
                }
                catch (Exception ex) {
                    if (this.isSilent) {
                        return null;
                    }
                    throw new BeanException("Invalid list element: " + bp.name + '[' + index + ']', bp, ex);
                }
                list.set(index, value);
            }
            return value;
        }
        if (resultBean instanceof Map) {
            Map map = (Map)resultBean;
            Object key = this.convertIndexToMapKey(getter, bp.indexString);
            if (!this.isForced) {
                return map.get(key);
            }
            Object value = map.get(key);
            if (!bp.last && value == null) {
                Class<Map> mapComponentType = this.extractGenericComponentType(getter);
                if (mapComponentType == Object.class) {
                    mapComponentType = Map.class;
                }
                try {
                    value = ClassUtil.newInstance(mapComponentType);
                }
                catch (Exception ex) {
                    if (this.isSilent) {
                        return null;
                    }
                    throw new BeanException("Invalid map element: " + bp.name + '[' + bp.indexString + ']', bp, ex);
                }
                map.put(key, value);
            }
            return value;
        }
        if (this.isSilent) {
            return null;
        }
        throw new BeanException("Index property is not an array, list or map: " + bp.name, bp);
    }

    @Override
    public void setIndexProperty(Object bean, String property, int index, Object value) {
        BeanProperty bp = new BeanProperty(this, bean, property);
        bp.indexString = bp.index = String.valueOf(index);
        this._setIndexProperty(bp, value);
        bp.indexString = null;
    }

    protected void setIndexProperty(BeanProperty bp, Object value) {
        bp.indexString = this.extractIndex(bp);
        this._setIndexProperty(bp, value);
        bp.indexString = null;
    }

    private void _setIndexProperty(BeanProperty bp, Object value) {
        if (bp.indexString == null) {
            this.setSimpleProperty(bp, value);
            return;
        }
        Object nextBean = this.getSimpleProperty(bp);
        Getter getter = bp.getGetter(this.isDeclared);
        if (nextBean == null) {
            if (this.isSilent) {
                return;
            }
            throw new BeanException("Index property is null:" + bp.name, bp);
        }
        if (nextBean.getClass().isArray()) {
            int index = this.parseInt(bp.indexString, bp);
            if (this.isForced) {
                this.arrayForcedSet(bp, nextBean, index, value);
            } else {
                Array.set(nextBean, index, value);
            }
            return;
        }
        if (nextBean instanceof List) {
            int index = this.parseInt(bp.indexString, bp);
            Class listComponentType = this.extractGenericComponentType(getter);
            if (listComponentType != Object.class) {
                value = this.convertType(value, listComponentType);
            }
            List list = (List)nextBean;
            if (this.isForced) {
                this.ensureListSize(list, index);
            }
            list.set(index, value);
            return;
        }
        if (nextBean instanceof Map) {
            Map map = (Map)nextBean;
            Object key = this.convertIndexToMapKey(getter, bp.indexString);
            Class mapComponentType = this.extractGenericComponentType(getter);
            if (mapComponentType != Object.class) {
                value = this.convertType(value, mapComponentType);
            }
            map.put(key, value);
            return;
        }
        if (this.isSilent) {
            return;
        }
        throw new BeanException("Index property is not an array, list or map: " + bp.name, bp);
    }

    @Override
    public void setProperty(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(this, bean, name);
        if (!this.isSilent) {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value);
        } else {
            try {
                this.resolveNestedProperties(beanProperty);
                this.setIndexProperty(beanProperty, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public <T> T getProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(this, bean, name);
        if (!this.isSilent) {
            this.resolveNestedProperties(beanProperty);
            return (T)this.getIndexProperty(beanProperty);
        }
        try {
            this.resolveNestedProperties(beanProperty);
            return (T)this.getIndexProperty(beanProperty);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Override
    public boolean hasProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(this, bean, name);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return false;
        }
        return this.hasIndexProperty(beanProperty);
    }

    @Override
    public boolean hasRootProperty(Object bean, String name) {
        int dotNdx = this.indexOfDot(name);
        if (dotNdx != -1) {
            name = name.substring(0, dotNdx);
        }
        BeanProperty beanProperty = new BeanProperty(this, bean, name);
        this.extractIndex(beanProperty);
        return this.hasSimpleProperty(beanProperty);
    }

    @Override
    public Class<?> getPropertyType(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(this, bean, name);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return null;
        }
        this.hasIndexProperty(beanProperty);
        return this.extractType(beanProperty);
    }

    @Override
    public String extractThisReference(String propertyName) {
        int ndx = StringUtil.indexOfChars(propertyName, INDEX_CHARS);
        if (ndx == -1) {
            return propertyName;
        }
        return propertyName.substring(0, ndx);
    }
}

