/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.document;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jodconverter.document.DocumentFamily;

public class DocumentFormat {
    private final String name;
    @SerializedName(value="extensions", alternate={"extension"})
    @JsonAdapter(value=ExtensionsAdapter.class)
    private final List<String> extensions;
    private final String mediaType;
    private final DocumentFamily inputFamily;
    private final Map<String, Object> loadProperties;
    @SerializedName(value="storeProperties", alternate={"storePropertiesByFamily"})
    private final Map<DocumentFamily, Map<String, Object>> storeProperties;

    public static Builder builder() {
        return new Builder();
    }

    public static DocumentFormat copy(DocumentFormat sourceFormat) {
        return new Builder().from(sourceFormat).unmodifiable(false).build();
    }

    public static DocumentFormat unmodifiableCopy(DocumentFormat sourceFormat) {
        return new Builder().from(sourceFormat).unmodifiable(true).build();
    }

    private DocumentFormat(String name, Collection<String> extensions, String mediaType, DocumentFamily inputFamily, Map<String, Object> loadProperties, Map<DocumentFamily, Map<String, Object>> storeProperties, boolean unmodifiable) {
        this.name = name;
        this.extensions = new ArrayList<String>(extensions);
        this.mediaType = mediaType;
        this.inputFamily = inputFamily;
        this.loadProperties = Optional.ofNullable(loadProperties).map(HashMap::new).map(mapCopy -> unmodifiable ? Collections.unmodifiableMap(mapCopy) : mapCopy).orElse(null);
        this.storeProperties = Optional.ofNullable(storeProperties).map(map -> {
            EnumMap familyMap = new EnumMap(DocumentFamily.class);
            map.forEach((family, propMap) -> {
                Map cfr_ignored_0 = familyMap.put((DocumentFamily)((Object)((Object)family)), unmodifiable ? Collections.unmodifiableMap(new HashMap(propMap)) : new HashMap(propMap));
            });
            return familyMap;
        }).map(mapCopy -> unmodifiable ? Collections.unmodifiableMap(mapCopy) : mapCopy).orElse(null);
    }

    public String getExtension() {
        return this.extensions.get(0);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public DocumentFamily getInputFamily() {
        return this.inputFamily;
    }

    public Map<String, Object> getLoadProperties() {
        return this.loadProperties;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getName() {
        return this.name;
    }

    public Map<DocumentFamily, Map<String, Object>> getStoreProperties() {
        return this.storeProperties;
    }

    public Map<String, Object> getStoreProperties(DocumentFamily family) {
        return this.storeProperties == null ? null : this.storeProperties.get((Object)family);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static final class Builder {
        private String name;
        private Set<String> extensions;
        private String mediaType;
        private DocumentFamily inputFamily;
        private Map<String, Object> loadProperties;
        private Map<DocumentFamily, Map<String, Object>> storeProperties;
        private boolean unmodifiable = true;

        private Builder() {
        }

        public DocumentFormat build() {
            return new DocumentFormat(this.name, this.extensions, this.mediaType, this.inputFamily, this.loadProperties, this.storeProperties, this.unmodifiable);
        }

        public Builder from(DocumentFormat sourceFormat) {
            Validate.notNull((Object)sourceFormat);
            this.name = sourceFormat.getName();
            this.extensions = new LinkedHashSet<String>(sourceFormat.getExtensions());
            this.mediaType = sourceFormat.getMediaType();
            this.inputFamily = sourceFormat.getInputFamily();
            this.loadProperties = Optional.ofNullable(sourceFormat.getLoadProperties()).map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(null);
            this.storeProperties = Optional.ofNullable(sourceFormat.getStoreProperties()).map(map -> {
                EnumMap familyMap = new EnumMap(DocumentFamily.class);
                map.forEach((family, propMap) -> {
                    Map cfr_ignored_0 = familyMap.put((DocumentFamily)((Object)((Object)family)), new HashMap(propMap));
                });
                return familyMap;
            }).orElse(null);
            return this;
        }

        public Builder extension(String extension) {
            Validate.notBlank((CharSequence)extension);
            if (this.extensions == null) {
                this.extensions = new LinkedHashSet<String>();
            }
            this.extensions.add(extension);
            return this;
        }

        public Builder inputFamily(DocumentFamily inputFamily) {
            Validate.notNull((Object)((Object)inputFamily));
            this.inputFamily = inputFamily;
            return this;
        }

        public Builder loadProperty(String name, Object value) {
            Validate.notBlank((CharSequence)name);
            if (value == null) {
                Optional.ofNullable(this.loadProperties).ifPresent(propMap -> propMap.remove(name));
            } else {
                if (this.loadProperties == null) {
                    this.loadProperties = new HashMap<String, Object>();
                }
                this.loadProperties.put(name, value);
            }
            return this;
        }

        public Builder mediaType(String mediaType) {
            Validate.notBlank((CharSequence)mediaType);
            this.mediaType = mediaType;
            return this;
        }

        public Builder name(String name) {
            Validate.notBlank((CharSequence)name);
            this.name = name;
            return this;
        }

        public Builder unmodifiable(boolean unmodifiable) {
            this.unmodifiable = unmodifiable;
            return this;
        }

        public Builder storeProperty(DocumentFamily family, String name, Object value) {
            Validate.notBlank((CharSequence)name);
            Validate.notNull((Object)((Object)family));
            if (value == null) {
                Optional.ofNullable(this.storeProperties).map(familyMap -> (Map)familyMap.get((Object)family)).ifPresent(propMap -> propMap.remove(name));
            } else {
                if (this.storeProperties == null) {
                    this.storeProperties = new EnumMap<DocumentFamily, Map<String, Object>>(DocumentFamily.class);
                }
                this.storeProperties.computeIfAbsent(family, key -> new HashMap()).put(name, value);
            }
            return this;
        }
    }

    private static class ExtensionsAdapter
    implements JsonDeserializer<List<String>> {
        private ExtensionsAdapter() {
        }

        public List<String> deserialize(JsonElement json, Type type, JsonDeserializationContext cxt) {
            if (json.isJsonArray()) {
                Type listType = new TypeToken<List<String>>(){}.getType();
                return (List)cxt.deserialize(json, listType);
            }
            return Stream.of(json.getAsString()).collect(Collectors.toList());
        }
    }
}

