/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import java.util.Arrays;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class NumericObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new NumericObjectArrayStringConverterFactory();

    private NumericObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls.isArray()) {
            if (cls == Long[].class) {
                return LongArrayStringConverter.INSTANCE;
            }
            if (cls == Integer[].class) {
                return IntArrayStringConverter.INSTANCE;
            }
            if (cls == Short[].class) {
                return ShortArrayStringConverter.INSTANCE;
            }
            if (cls == Double[].class) {
                return DoubleArrayStringConverter.INSTANCE;
            }
            if (cls == Float[].class) {
                return FloatArrayStringConverter.INSTANCE;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum FloatArrayStringConverter implements TypedStringConverter<Float[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Float[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Float[] convertFromString(Class<? extends Float[]> cls, String str) {
                String split;
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count = 0;
                int base = 0;
                int sep = str.indexOf(44);
                Float[] array = new Float[str.length() / 2 + 1];
                while (sep >= 0) {
                    split = str.substring(base, sep);
                    array[count++] = split.equals("-") ? null : new Float(split);
                    base = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                split = str.substring(base, str.length());
                array[count++] = split.equals("-") ? null : new Float(split);
                return Arrays.copyOf(array, count);
            }

            @Override
            public Class<?> getEffectiveType() {
                return Float[].class;
            }
        };

        private static final Float[] EMPTY;

        static {
            EMPTY = new Float[0];
        }
    }

    static enum DoubleArrayStringConverter implements TypedStringConverter<Double[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Double[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Double[] convertFromString(Class<? extends Double[]> cls, String str) {
                String split;
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count = 0;
                int base = 0;
                int sep = str.indexOf(44);
                Double[] array = new Double[str.length() / 2 + 1];
                while (sep >= 0) {
                    split = str.substring(base, sep);
                    array[count++] = split.equals("-") ? null : new Double(split);
                    base = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                split = str.substring(base, str.length());
                array[count++] = split.equals("-") ? null : new Double(split);
                return Arrays.copyOf(array, count);
            }

            @Override
            public Class<?> getEffectiveType() {
                return Double[].class;
            }
        };

        private static final Double[] EMPTY;

        static {
            EMPTY = new Double[0];
        }
    }

    static enum ShortArrayStringConverter implements TypedStringConverter<Short[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Short[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 3);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Short[] convertFromString(Class<? extends Short[]> cls, String str) {
                String split;
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count = 0;
                int base = 0;
                int sep = str.indexOf(44);
                Short[] array = new Short[str.length() / 2 + 1];
                while (sep >= 0) {
                    split = str.substring(base, sep);
                    array[count++] = split.equals("-") ? null : new Short(split);
                    base = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                split = str.substring(base, str.length());
                array[count++] = split.equals("-") ? null : new Short(split);
                return Arrays.copyOf(array, count);
            }

            @Override
            public Class<?> getEffectiveType() {
                return Short[].class;
            }
        };

        private static final Short[] EMPTY;

        static {
            EMPTY = new Short[0];
        }
    }

    static enum IntArrayStringConverter implements TypedStringConverter<Integer[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Integer[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 6);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Integer[] convertFromString(Class<? extends Integer[]> cls, String str) {
                String split;
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count = 0;
                int base = 0;
                int sep = str.indexOf(44);
                Integer[] array = new Integer[str.length() / 2 + 1];
                while (sep >= 0) {
                    split = str.substring(base, sep);
                    array[count++] = split.equals("-") ? null : new Integer(split);
                    base = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                split = str.substring(base, str.length());
                array[count++] = split.equals("-") ? null : new Integer(split);
                return Arrays.copyOf(array, count);
            }

            @Override
            public Class<?> getEffectiveType() {
                return Integer[].class;
            }
        };

        private static final Integer[] EMPTY;

        static {
            EMPTY = new Integer[0];
        }
    }

    static enum LongArrayStringConverter implements TypedStringConverter<Long[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Long[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Long[] convertFromString(Class<? extends Long[]> cls, String str) {
                String split;
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count = 0;
                int base = 0;
                int sep = str.indexOf(44);
                Long[] array = new Long[str.length() / 2 + 1];
                while (sep >= 0) {
                    split = str.substring(base, sep);
                    array[count++] = split.equals("-") ? null : new Long(split);
                    base = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                split = str.substring(base, str.length());
                array[count++] = split.equals("-") ? null : new Long(split);
                return Arrays.copyOf(array, count);
            }

            @Override
            public Class<?> getEffectiveType() {
                return Long[].class;
            }
        };

        private static final Long[] EMPTY;

        static {
            EMPTY = new Long[0];
        }
    }
}

