/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.terrain.heightmap.AbstractHeightMap;
import java.util.Random;
import java.util.logging.Logger;

public class FluidSimHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(FluidSimHeightMap.class.getName());
    private float waveSpeed = 100.0f;
    private float timeStep = 0.033f;
    private float nodeDistance = 10.0f;
    private float viscosity = 100.0f;
    private int iterations;
    private float minInitialHeight = -500.0f;
    private float maxInitialHeight = 500.0f;
    private long seed;
    float coefA;
    float coefB;
    float coefC;

    public FluidSimHeightMap(int size, int iterations, float minInitialHeight, float maxInitialHeight, float viscosity, float waveSpeed, float timestep, float nodeDistance, long seed) throws Exception {
        if (size <= 0 || iterations <= 0 || minInitialHeight >= maxInitialHeight) {
            throw new Exception("Either size of the terrain is not greater that zero, or number of iterations is not greater that zero, or minimum height greater or equal as the maximum, or maximum height smaller or equal as the minimum.");
        }
        this.size = size;
        this.seed = seed;
        this.iterations = iterations;
        this.minInitialHeight = minInitialHeight;
        this.maxInitialHeight = maxInitialHeight;
        this.viscosity = viscosity;
        this.waveSpeed = waveSpeed;
        this.timeStep = timestep;
        this.nodeDistance = nodeDistance;
        this.load();
    }

    public FluidSimHeightMap(int size, int iterations) throws Exception {
        if (size <= 0 || iterations <= 0) {
            throw new Exception("Either size of the terrain is not greater than zero, or number of iterations is not greater than zero");
        }
        this.size = size;
        this.iterations = iterations;
        this.load();
    }

    @Override
    public boolean load() {
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new float[this.size * this.size];
        float[][] tempBuffer = new float[2][this.size * this.size];
        Random random = new Random(this.seed);
        this.coefA = (4.0f - 8.0f * this.waveSpeed * this.waveSpeed * this.timeStep * this.timeStep / (this.nodeDistance * this.nodeDistance)) / (this.viscosity * this.timeStep + 2.0f);
        this.coefB = (this.viscosity * this.timeStep - 2.0f) / (this.viscosity * this.timeStep + 2.0f);
        this.coefC = 2.0f * this.waveSpeed * this.waveSpeed * this.timeStep * this.timeStep / (this.nodeDistance * this.nodeDistance) / (this.viscosity * this.timeStep + 2.0f);
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                float f = this.randomRange(random, this.minInitialHeight, this.maxInitialHeight);
                tempBuffer[1][j + i * this.size] = f;
                tempBuffer[0][j + i * this.size] = f;
            }
        }
        int curBuf = 0;
        for (int i = 0; i < this.iterations; ++i) {
            float[] oldBuffer = tempBuffer[1 - curBuf];
            float[] newBuffer = tempBuffer[curBuf];
            for (int y = 0; y < this.size; ++y) {
                for (int x = 0; x < this.size; ++x) {
                    int ind = x + y * this.size;
                    float neighborsValue = 0.0f;
                    int neighbors = 0;
                    if (x > 0) {
                        neighborsValue += newBuffer[ind - 1];
                        ++neighbors;
                    }
                    if (x < this.size - 1) {
                        neighborsValue += newBuffer[ind + 1];
                        ++neighbors;
                    }
                    if (y > 0) {
                        neighborsValue += newBuffer[ind - this.size];
                        ++neighbors;
                    }
                    if (y < this.size - 1) {
                        neighborsValue += newBuffer[ind + this.size];
                        ++neighbors;
                    }
                    if (neighbors != 4) {
                        neighborsValue *= (float)(4 / neighbors);
                    }
                    oldBuffer[ind] = this.coefA * newBuffer[ind] + this.coefB * oldBuffer[ind] + this.coefC * neighborsValue;
                }
            }
            curBuf = 1 - curBuf;
        }
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.size; ++x) {
                this.heightData[x + y * this.size] = tempBuffer[curBuf][x + y * this.size];
            }
        }
        this.normalizeTerrain(NORMALIZE_RANGE);
        logger.fine("Created Heightmap using fluid simulation");
        return true;
    }

    private float randomRange(Random random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public void setIterations(int iterations) throws Exception {
        if (iterations <= 0) {
            throw new Exception("Number of iterations is not greater than zero");
        }
        this.iterations = iterations;
    }

    public void setMaxInitialHeight(float maxInitialHeight) {
        this.maxInitialHeight = maxInitialHeight;
    }

    public void setMinInitialHeight(float minInitialHeight) {
        this.minInitialHeight = minInitialHeight;
    }

    public void setNodeDistance(float nodeDistance) {
        this.nodeDistance = nodeDistance;
    }

    public void setTimeStep(float timeStep) {
        this.timeStep = timeStep;
    }

    public void setViscosity(float viscosity) {
        this.viscosity = viscosity;
    }

    public void setWaveSpeed(float waveSpeed) {
        this.waveSpeed = waveSpeed;
    }
}

