/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.executor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TerrainExecutorService {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static volatile Callable<ExecutorService> constructor = new Callable<ExecutorService>(){

        @Override
        public ExecutorService call() throws Exception {
            return Executors.newFixedThreadPool(RUNTIME.availableProcessors(), new ThreadFactory(){
                private final AtomicInteger counter = new AtomicInteger(-1);

                @Override
                public Thread newThread(Runnable task) {
                    Thread thread = new Thread(task);
                    thread.setName("jME3 Terrain Thread [" + this.counter.incrementAndGet() + "]");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
    };
    private static LazyInitializer initializer;
    private final ExecutorService executorService;

    public static void setConstructor(Callable<ExecutorService> constructor) {
        TerrainExecutorService.constructor = constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TerrainExecutorService getInstance() {
        LazyInitializer lazy = initializer;
        if (lazy != null) return lazy.instance;
        Class<TerrainExecutorService> clazz = TerrainExecutorService.class;
        synchronized (TerrainExecutorService.class) {
            lazy = initializer;
            if (lazy != null) return lazy.instance;
            initializer = lazy = new LazyInitializer(new TerrainExecutorService());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return lazy.instance;
        }
    }

    private TerrainExecutorService() {
        try {
            this.executorService = constructor.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }

    public Future<?> submit(Runnable task) {
        return this.executorService.submit(task);
    }

    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    private static class LazyInitializer {
        public final TerrainExecutorService instance;

        public LazyInitializer(TerrainExecutorService instance) {
            this.instance = instance;
        }
    }
}

