/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.DistanceLodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import com.jme3.util.SafeArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MultiTerrainLodControl
extends TerrainLodControl {
    private SafeArrayList<TerrainQuad> terrains = new SafeArrayList(TerrainQuad.class);
    private List<TerrainQuad> addedTerrains;
    private List<TerrainQuad> removedTerrains = new ArrayList<TerrainQuad>();

    public MultiTerrainLodControl() {
        this.addedTerrains = new ArrayList<TerrainQuad>();
    }

    public MultiTerrainLodControl(Terrain terrain) {
        this();
        this.setTerrain(terrain);
    }

    public MultiTerrainLodControl(Camera camera) {
        this();
        this.setCamera(camera);
    }

    public MultiTerrainLodControl(Terrain terrain, Camera camera) {
        this(terrain);
        this.setCamera(camera);
    }

    public MultiTerrainLodControl(Terrain terrain, List<Camera> cameras) {
        this(terrain);
        this.setCameras(cameras);
    }

    @Override
    protected DistanceLodCalculator makeLodCalculator() {
        return new DistanceLodCalculator(65, 2.7f);
    }

    public void addTerrain(TerrainQuad tq) {
        this.addedTerrains.add(tq);
    }

    public void removeTerrain(TerrainQuad tq) {
        this.removedTerrains.add(tq);
    }

    @Override
    protected TerrainLodControl.UpdateLOD createLodUpdateTask(List<Vector3f> locations, LodCalculator lodCalculator) {
        return new UpdateMultiLOD(locations, lodCalculator);
    }

    @Override
    protected void prepareTerrain() {
        if (!this.addedTerrains.isEmpty()) {
            for (TerrainQuad t : this.addedTerrains) {
                if (this.terrains.contains((Object)t)) continue;
                this.terrains.add((Object)t);
            }
            this.addedTerrains.clear();
        }
        if (!this.removedTerrains.isEmpty()) {
            this.terrains.removeAll(this.removedTerrains);
            this.removedTerrains.clear();
        }
        for (TerrainQuad terrain : (TerrainQuad[])this.terrains.getArray()) {
            terrain.cacheTerrainTransforms();
        }
    }

    protected class UpdateMultiLOD
    extends TerrainLodControl.UpdateLOD {
        protected UpdateMultiLOD(List<Vector3f> camLocations, LodCalculator lodCalculator) {
            super(MultiTerrainLodControl.this, camLocations, lodCalculator);
        }

        @Override
        public HashMap<String, UpdatedTerrainPatch> call() throws Exception {
            HashMap<String, UpdatedTerrainPatch> updated = new HashMap<String, UpdatedTerrainPatch>();
            for (TerrainQuad terrainQuad : MultiTerrainLodControl.this.terrains) {
                terrainQuad.calculateLod(this.camLocations, updated, this.lodCalculator);
            }
            for (TerrainQuad terrainQuad : MultiTerrainLodControl.this.terrains) {
                terrainQuad.findNeighboursLod(updated);
            }
            for (TerrainQuad terrainQuad : MultiTerrainLodControl.this.terrains) {
                terrainQuad.fixEdges(updated);
            }
            for (TerrainQuad terrainQuad : MultiTerrainLodControl.this.terrains) {
                terrainQuad.reIndexPages(updated, this.lodCalculator.usesVariableLod());
            }
            MultiTerrainLodControl.this.lodCalcRunning.set(false);
            return updated;
        }
    }
}

