/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugin.export.materialdef;

import com.jme3.material.MatParam;
import com.jme3.material.MatParamTexture;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.texture.image.ColorSpace;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class J3mdMatParamWriter {
    public void write(MatParam param, OutputStreamWriter out) throws IOException {
        String value;
        out.write("        ");
        out.write(param.getVarType().name());
        out.write(" ");
        out.write(param.getName());
        if (param instanceof MatParamTexture) {
            String space;
            MatParamTexture paramTex = (MatParamTexture)param;
            String string = space = paramTex.getColorSpace() == ColorSpace.Linear ? "-LINEAR" : null;
            if (space != null) {
                out.write(" ");
                out.write(space);
            }
        }
        if ((value = this.formatValue(param)) != null) {
            out.write(" : ");
            out.write(value);
        }
        out.write("\n");
    }

    private String formatValue(MatParam param) {
        Object value = param.getValue();
        if (value == null) {
            return null;
        }
        switch (param.getVarType()) {
            case Vector2: {
                Vector2f v2 = (Vector2f)value;
                return v2.getX() + " " + v2.getY();
            }
            case Vector3: {
                Vector3f v3 = (Vector3f)value;
                return v3.getX() + " " + v3.getY() + " " + v3.getZ();
            }
            case Vector4: {
                if (value instanceof ColorRGBA) {
                    ColorRGBA c = (ColorRGBA)value;
                    return c.getRed() + " " + c.getGreen() + " " + c.getBlue() + " " + c.getAlpha();
                }
                Vector4f v4 = (Vector4f)value;
                return v4.getX() + " " + v4.getY() + " " + v4.getZ() + " " + v4.getW();
            }
        }
        return value.toString();
    }
}

