/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.input.AWTKeyInput;
import com.jme3.input.AWTMouseInput;
import com.jme3.input.JoyInput;
import com.jme3.input.TouchInput;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.system.AppSettings;
import com.jme3.system.Displays;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;

public class AWTContext
implements JmeContext {
    protected final AppSettings settings;
    protected final AWTKeyInput keyInput = new AWTKeyInput(this);
    protected final AWTMouseInput mouseInput = new AWTMouseInput(this);
    private volatile int width = 1;
    private volatile int height = 1;
    protected JmeContext backgroundContext;

    public AWTContext() {
        this.settings = this.createSettings();
        this.backgroundContext = this.createBackgroundContext();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    protected AppSettings createSettings() {
        AppSettings settings = new AppSettings(true);
        settings.setRenderer("LWJGL-OpenGL3");
        return settings;
    }

    protected JmeContext createBackgroundContext() {
        return JmeSystem.newContext((AppSettings)this.settings, (JmeContext.Type)JmeContext.Type.OffscreenSurface);
    }

    public JmeContext.Type getType() {
        return JmeContext.Type.OffscreenSurface;
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        this.settings.setRenderer("LWJGL-OpenGL3");
        this.backgroundContext.setSettings(settings);
    }

    public SystemListener getSystemListener() {
        return this.backgroundContext.getSystemListener();
    }

    public void setSystemListener(SystemListener listener) {
        this.backgroundContext.setSystemListener(listener);
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.backgroundContext.getRenderer();
    }

    public Context getOpenCLContext() {
        return null;
    }

    public AWTMouseInput getMouseInput() {
        return this.mouseInput;
    }

    public AWTKeyInput getKeyInput() {
        return this.keyInput;
    }

    public JoyInput getJoyInput() {
        return null;
    }

    public TouchInput getTouchInput() {
        return null;
    }

    public Timer getTimer() {
        return this.backgroundContext.getTimer();
    }

    public void setTitle(String title) {
    }

    public boolean isCreated() {
        return this.backgroundContext != null && this.backgroundContext.isCreated();
    }

    public boolean isRenderable() {
        return this.backgroundContext != null && this.backgroundContext.isRenderable();
    }

    public void setAutoFlushFrames(boolean enabled) {
    }

    public void create(boolean waitFor) {
        String render = System.getProperty("awt.background.render", "LWJGL-OpenGL33");
        this.backgroundContext.getSettings().setRenderer(render);
        this.backgroundContext.create(waitFor);
    }

    public void restart() {
    }

    public void destroy(boolean waitFor) {
        if (this.backgroundContext == null) {
            throw new IllegalStateException("Not created");
        }
        this.backgroundContext.destroy(waitFor);
    }

    public int getFramebufferHeight() {
        return this.height;
    }

    public int getFramebufferWidth() {
        return this.width;
    }

    public int getWindowXPosition() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public int getWindowYPosition() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Displays getDisplays() {
        return null;
    }

    public int getPrimaryDisplay() {
        return 0;
    }
}

