/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.Application;
import com.jme3.app.LegacyApplication;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.system.JmeSystem;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AppletHarness
extends Applet {
    public static final HashMap<LegacyApplication, Applet> appToApplet = new HashMap();
    protected JmeCanvasContext context;
    protected Canvas canvas;
    protected LegacyApplication app;
    protected String appClass;
    protected URL appCfg = null;
    protected URL assetCfg = null;

    public static Applet getApplet(Application app) {
        return appToApplet.get(app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCanvas() {
        AppSettings settings = new AppSettings(true);
        if (this.appCfg != null) {
            InputStream in = null;
            try {
                in = this.appCfg.openStream();
                settings.load(in);
                in.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "An error has occurred while loading applet configuration" + ex.getMessage(), "jME3 Applet", 0);
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.assetCfg != null) {
            settings.putString("AssetConfigURL", this.assetCfg.toString());
        }
        settings.setWidth(this.getWidth());
        settings.setHeight(this.getHeight());
        JmeSystem.setLowPermissions((boolean)true);
        try {
            Class<?> clazz = Class.forName(this.appClass);
            this.app = (LegacyApplication)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
        appToApplet.put(this.app, this);
        this.app.setSettings(settings);
        this.app.createCanvas();
        this.context = (JmeCanvasContext)this.app.getContext();
        this.canvas = this.context.getCanvas();
        this.canvas.setSize(this.getWidth(), this.getHeight());
        this.add(this.canvas);
        this.app.startCanvas();
    }

    @Override
    public final void update(Graphics g) {
        this.canvas.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void init() {
        this.appClass = this.getParameter("AppClass");
        if (this.appClass == null) {
            throw new RuntimeException("The required parameter AppClass isn't specified!");
        }
        try {
            this.appCfg = new URL(this.getParameter("AppSettingsURL"));
        }
        catch (MalformedURLException ex) {
            System.out.println(ex.getMessage());
            this.appCfg = null;
        }
        try {
            this.assetCfg = new URL(this.getParameter("AssetConfigURL"));
        }
        catch (MalformedURLException ex) {
            System.out.println(ex.getMessage());
            this.assetCfg = this.getClass().getResource("/com/jme3/asset/Desktop.cfg");
        }
        this.createCanvas();
        System.out.println("applet:init");
    }

    @Override
    public void start() {
        this.context.setAutoFlushFrames(true);
        System.out.println("applet:start");
    }

    @Override
    public void stop() {
        this.context.setAutoFlushFrames(false);
        System.out.println("applet:stop");
    }

    @Override
    public void destroy() {
        System.out.println("applet:destroyStart");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppletHarness.this.removeAll();
                System.out.println("applet:destroyRemoved");
            }
        });
        this.app.stop(true);
        System.out.println("applet:destroyDone");
        appToApplet.remove(this.app);
    }
}

