/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.shader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Preprocessor {
    private static final Pattern FOR_REGEX = Pattern.compile("([^=]+)=\\s*([0-9]+)\\s*\\.\\.\\s*([0-9]+)\\s*\\((.+)\\)");
    private static final Pattern STRUCT_REGEX = Pattern.compile("(\\w+)(?:\\s+extends\\s+(\\w+(?:,\\s*\\w+)*))?");

    public static InputStream apply(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] chunk = new byte[1024];
        while ((read = in.read(chunk)) != -1) {
            bos.write(chunk, 0, read);
        }
        bos.close();
        in.close();
        String code = bos.toString("UTF-8");
        code = Preprocessor.forMacro(code);
        code = Preprocessor.structMacro(code);
        return new ByteArrayInputStream(code.getBytes("UTF-8"));
    }

    public static String forMacro(String code) {
        StringBuilder expandedCode = new StringBuilder();
        StringBuilder currentFor = null;
        String forDec = null;
        int skip = 0;
        String[] codel = code.split("\n");
        boolean captured = false;
        for (String l : codel) {
            if (!captured) {
                Matcher matcher;
                String ln = l.trim();
                if (ln.startsWith("#for")) {
                    if (skip == 0) {
                        forDec = ln;
                        currentFor = new StringBuilder();
                        ++skip;
                        continue;
                    }
                    ++skip;
                } else if (ln.startsWith("#endfor") && --skip == 0 && (matcher = FOR_REGEX.matcher(forDec = forDec.substring("#for ".length()).trim())).matches()) {
                    String varN = "$" + matcher.group(1);
                    int start = Integer.parseInt(matcher.group(2));
                    int end = Integer.parseInt(matcher.group(3));
                    String inj = matcher.group(4);
                    if (inj.trim().isEmpty()) {
                        inj = "$0";
                    }
                    String inCode = currentFor.toString();
                    currentFor = null;
                    for (int i = start; i < end; ++i) {
                        expandedCode.append("\n").append(inj.replace("$0", "\n" + inCode).replace(varN, "" + i)).append("\n");
                    }
                    captured = true;
                    continue;
                }
            }
            if (currentFor != null) {
                currentFor.append(l).append("\n");
                continue;
            }
            expandedCode.append(l).append("\n");
        }
        code = expandedCode.toString();
        if (captured) {
            code = Preprocessor.forMacro(code);
        }
        return code;
    }

    public static String structMacro(String code) {
        StringBuilder expandedCode = new StringBuilder();
        StringBuilder currentStruct = null;
        String structDec = null;
        int skip = 0;
        String[] codeLines = code.split("\n");
        boolean captured = false;
        for (String line : codeLines) {
            if (!captured) {
                Matcher matcher;
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("#struct")) {
                    if (skip == 0) {
                        structDec = trimmedLine;
                        currentStruct = new StringBuilder();
                        ++skip;
                        continue;
                    }
                    ++skip;
                } else if (trimmedLine.startsWith("#endstruct") && --skip == 0 && (matcher = STRUCT_REGEX.matcher(structDec = structDec.substring("#struct ".length()).trim())).matches()) {
                    String extendsStructs;
                    String structName = matcher.group(1);
                    if (structName == null) {
                        structName = "";
                    }
                    String[] extendedStructs = (extendsStructs = matcher.group(2)) != null ? extendsStructs.split(",\\s*") : new String[]{};
                    String structBody = currentStruct.toString();
                    structBody = structBody == null ? "" : structBody.replaceAll("\\s+$", "");
                    currentStruct = null;
                    expandedCode.append("#define STRUCT_").append(structName).append(" \\\n");
                    for (String extendedStruct : extendedStructs) {
                        expandedCode.append("STRUCT_").append(extendedStruct).append(" \\\n");
                    }
                    String[] structBodyLines = structBody.split("\n");
                    for (int i = 0; i < structBodyLines.length; ++i) {
                        String structBodyLine = structBodyLines[i];
                        if ((structBodyLine = structBodyLine.trim()) == "") continue;
                        int commentIndex = structBodyLine.indexOf("//");
                        if (commentIndex >= 0) {
                            structBodyLine = structBodyLine.substring(0, commentIndex);
                        }
                        expandedCode.append(structBodyLine);
                        if (i < structBodyLines.length - 1) {
                            expandedCode.append(" \\");
                        }
                        expandedCode.append("\n");
                    }
                    expandedCode.append("struct ").append(structName).append(" { \nSTRUCT_").append(structName).append("\n};\n");
                    captured = true;
                    continue;
                }
            }
            if (currentStruct != null) {
                currentStruct.append(line).append("\n");
                continue;
            }
            expandedCode.append(line).append("\n");
        }
        code = expandedCode.toString();
        if (captured) {
            code = Preprocessor.structMacro(code);
        }
        return code;
    }
}

