/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class TangentUtils {
    private TangentUtils() {
    }

    public static void generateBindPoseTangentsIfNecessary(Mesh mesh) {
        VertexBuffer tangents;
        if (mesh.getBuffer(VertexBuffer.Type.BindPosePosition) != null && (tangents = mesh.getBuffer(VertexBuffer.Type.Tangent)) != null) {
            VertexBuffer bindTangents = new VertexBuffer(VertexBuffer.Type.BindPoseTangent);
            bindTangents.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.Float, BufferUtils.clone(tangents.getData()));
            if (mesh.getBuffer(VertexBuffer.Type.BindPoseTangent) != null) {
                mesh.clearBuffer(VertexBuffer.Type.BindPoseTangent);
            }
            mesh.setBuffer(bindTangents);
            tangents.setUsage(VertexBuffer.Usage.Stream);
        }
    }

    public static Mesh genTbnLines(Mesh mesh, float scale) {
        if (mesh.getBuffer(VertexBuffer.Type.Tangent) == null) {
            return TangentUtils.genNormalLines(mesh, scale);
        }
        return TangentUtils.genTangentLines(mesh, scale);
    }

    public static Mesh genNormalLines(Mesh mesh, float scale) {
        FloatBuffer vertexBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        FloatBuffer normalBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Normal).getData();
        ColorRGBA originColor = ColorRGBA.White;
        ColorRGBA normalColor = ColorRGBA.Blue;
        Mesh lineMesh = new Mesh();
        lineMesh.setMode(Mesh.Mode.Lines);
        Vector3f origin = new Vector3f();
        Vector3f point = new Vector3f();
        FloatBuffer lineVertex = BufferUtils.createFloatBuffer(vertexBuffer.limit() * 2);
        FloatBuffer lineColor = BufferUtils.createFloatBuffer(vertexBuffer.limit() / 3 * 4 * 2);
        for (int i = 0; i < vertexBuffer.limit() / 3; ++i) {
            BufferUtils.populateFromBuffer(origin, vertexBuffer, i);
            BufferUtils.populateFromBuffer(point, normalBuffer, i);
            int index = i * 2;
            BufferUtils.setInBuffer(origin, lineVertex, index);
            BufferUtils.setInBuffer(originColor, lineColor, index);
            point.multLocal(scale);
            point.addLocal(origin);
            BufferUtils.setInBuffer(point, lineVertex, index + 1);
            BufferUtils.setInBuffer(normalColor, lineColor, index + 1);
        }
        lineMesh.setBuffer(VertexBuffer.Type.Position, 3, lineVertex);
        lineMesh.setBuffer(VertexBuffer.Type.Color, 4, lineColor);
        lineMesh.setStatic();
        return lineMesh;
    }

    public static Mesh genTangentLines(Mesh mesh, float scale) {
        FloatBuffer vertexBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        FloatBuffer normalBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Normal).getData();
        FloatBuffer tangentBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Tangent).getData();
        FloatBuffer binormalBuffer = null;
        if (mesh.getBuffer(VertexBuffer.Type.Binormal) != null) {
            binormalBuffer = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Binormal).getData();
        }
        ColorRGBA originColor = ColorRGBA.White;
        ColorRGBA tangentColor = ColorRGBA.Red;
        ColorRGBA binormalColor = ColorRGBA.Green;
        ColorRGBA normalColor = ColorRGBA.Blue;
        Mesh lineMesh = new Mesh();
        lineMesh.setMode(Mesh.Mode.Lines);
        Vector3f origin = new Vector3f();
        Vector3f point = new Vector3f();
        Vector3f tangent = new Vector3f();
        Vector3f normal = new Vector3f();
        IntBuffer lineIndex = BufferUtils.createIntBuffer(vertexBuffer.limit() / 3 * 6);
        FloatBuffer lineVertex = BufferUtils.createFloatBuffer(vertexBuffer.limit() * 4);
        FloatBuffer lineColor = BufferUtils.createFloatBuffer(vertexBuffer.limit() / 3 * 4 * 4);
        boolean hasParity = mesh.getBuffer(VertexBuffer.Type.Tangent).getNumComponents() == 4;
        float tangentW = 1.0f;
        for (int i = 0; i < vertexBuffer.limit() / 3; ++i) {
            BufferUtils.populateFromBuffer(origin, vertexBuffer, i);
            BufferUtils.populateFromBuffer(normal, normalBuffer, i);
            if (hasParity) {
                tangent.x = tangentBuffer.get(i * 4);
                tangent.y = tangentBuffer.get(i * 4 + 1);
                tangent.z = tangentBuffer.get(i * 4 + 2);
                tangentW = tangentBuffer.get(i * 4 + 3);
            } else {
                BufferUtils.populateFromBuffer(tangent, tangentBuffer, i);
            }
            int index = i * 4;
            int id = i * 6;
            lineIndex.put(id, index);
            lineIndex.put(id + 1, index + 1);
            lineIndex.put(id + 2, index);
            lineIndex.put(id + 3, index + 2);
            lineIndex.put(id + 4, index);
            lineIndex.put(id + 5, index + 3);
            BufferUtils.setInBuffer(origin, lineVertex, index);
            BufferUtils.setInBuffer(originColor, lineColor, index);
            point.set(tangent);
            point.multLocal(scale);
            point.addLocal(origin);
            BufferUtils.setInBuffer(point, lineVertex, index + 1);
            BufferUtils.setInBuffer(tangentColor, lineColor, index + 1);
            if (binormalBuffer == null) {
                normal.cross(tangent, point);
                point.multLocal(-tangentW);
                point.normalizeLocal();
            } else {
                BufferUtils.populateFromBuffer(point, binormalBuffer, i);
            }
            point.multLocal(scale);
            point.addLocal(origin);
            BufferUtils.setInBuffer(point, lineVertex, index + 2);
            BufferUtils.setInBuffer(binormalColor, lineColor, index + 2);
            point.set(normal);
            point.multLocal(scale);
            point.addLocal(origin);
            BufferUtils.setInBuffer(point, lineVertex, index + 3);
            BufferUtils.setInBuffer(normalColor, lineColor, index + 3);
        }
        lineMesh.setBuffer(VertexBuffer.Type.Index, 1, lineIndex);
        lineMesh.setBuffer(VertexBuffer.Type.Position, 3, lineVertex);
        lineMesh.setBuffer(VertexBuffer.Type.Color, 4, lineColor);
        lineMesh.setStatic();
        return lineMesh;
    }
}

