/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.renderer.opengl.GL4;
import com.jme3.renderer.opengl.TextureUtil;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import java.util.Objects;

public class TextureImage {
    private Texture texture;
    private int level;
    private int layer;
    private Access access;
    private boolean updateFlag = true;

    public TextureImage(Texture texture) {
        this(texture, 0, -1, Access.ReadWrite);
    }

    public TextureImage(Texture texture, Access access) {
        this(texture, 0, -1, access);
    }

    public TextureImage(Texture texture, int level, int layer) {
        this(texture, level, layer, Access.ReadWrite);
    }

    public TextureImage(Texture texture, int level, int layer, Access access) {
        this.texture = Objects.requireNonNull(texture, "Underlying texture cannot be null");
        this.level = level;
        this.layer = layer;
        this.access = access;
        if (this.level < 0) {
            throw new IllegalArgumentException("Level cannot be less than zero.");
        }
    }

    public void bindImage(GL4 gl4, TextureUtil texUtil, int unit) {
        Image img = this.texture.getImage();
        gl4.glBindImageTexture(unit, img.getId(), this.level, this.isLayered(), Math.max(this.layer, 0), this.access.getGlEnum(), texUtil.getImageFormat((Image.Format)img.getFormat(), (boolean)false).internalFormat);
    }

    public void setUpdateNeeded() {
        this.updateFlag = true;
    }

    public boolean clearUpdateNeeded() {
        boolean f = this.updateFlag;
        this.updateFlag = false;
        return f;
    }

    public void setTexture(Texture texture) {
        Objects.requireNonNull(texture, "Wrapped texture cannot be null.");
        if (this.texture != texture) {
            this.texture = texture;
            this.updateFlag = true;
        }
    }

    public void setLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Texture image level cannot be negative.");
        }
        if (this.level != level) {
            this.level = level;
            this.updateFlag = true;
        }
    }

    public void setLayer(int layer) {
        if (this.layer != layer && (this.layer >= 0 || layer >= 0)) {
            this.layer = layer;
            this.updateFlag = true;
        }
    }

    public void setAccess(Access access) {
        if (this.access != access) {
            this.access = access;
            this.updateFlag = true;
        }
    }

    public Texture getTexture() {
        return this.texture;
    }

    public Image getImage() {
        return this.texture.getImage();
    }

    public Image.Format getFormat() {
        return this.texture.getImage().getFormat();
    }

    public int getImageId() {
        return this.texture.getImage().getId();
    }

    public int getLevel() {
        return this.level;
    }

    public int getLayer() {
        return this.layer;
    }

    public Access getAccess() {
        return this.access;
    }

    public boolean isLayered() {
        return this.layer < 0;
    }

    public boolean isUpdateNeeded() {
        return this.updateFlag;
    }

    public static enum Access {
        ReadOnly(true, false, 35000),
        WriteOnly(false, true, 35001),
        ReadWrite(true, true, 35002);

        private final boolean read;
        private final boolean write;
        private final int glEnum;

        private Access(boolean read, boolean write, int glEnum) {
            this.read = read;
            this.write = write;
            this.glEnum = glEnum;
        }

        public boolean isRead() {
            return this.read;
        }

        public boolean isWrite() {
            return this.write;
        }

        public int getGlEnum() {
            return this.glEnum;
        }
    }
}

