/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.dummy.DummyKeyInput;
import com.jme3.input.dummy.DummyMouseInput;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.system.AppSettings;
import com.jme3.system.Displays;
import com.jme3.system.JmeContext;
import com.jme3.system.NanoTimer;
import com.jme3.system.NullRenderer;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NullContext
implements JmeContext,
Runnable {
    protected static final Logger logger = Logger.getLogger(NullContext.class.getName());
    protected static final String THREAD_NAME = "jME3 Headless Main";
    protected AtomicBoolean created = new AtomicBoolean(false);
    protected AtomicBoolean needClose = new AtomicBoolean(false);
    protected final Object createdLock = new Object();
    protected int frameRate;
    protected AppSettings settings = new AppSettings(true);
    protected Timer timer;
    protected SystemListener listener;
    protected NullRenderer renderer;
    private long timeThen;
    private long timeLate;

    @Override
    public JmeContext.Type getType() {
        return JmeContext.Type.Headless;
    }

    @Override
    public SystemListener getSystemListener() {
        return this.listener;
    }

    @Override
    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInThread() {
        logger.fine("NullContext created.");
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Running on thread: {0}", Thread.currentThread().getName());
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable thrown) {
                NullContext.this.listener.handleError("Uncaught exception thrown in " + thread.toString(), thrown);
            }
        });
        this.timer = new NanoTimer();
        this.renderer = new NullRenderer();
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(true);
            this.createdLock.notifyAll();
        }
        this.listener.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deinitInThread() {
        this.listener.destroy();
        this.timer = null;
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(false);
            this.createdLock.notifyAll();
        }
    }

    public void sync(int fps) {
        long gapTo = this.timer.getResolution() / (long)fps + this.timeThen;
        long timeNow = this.timer.getTime();
        long savedTimeLate = this.timeLate;
        try {
            while (gapTo > timeNow + savedTimeLate) {
                Thread.sleep(1L);
                timeNow = this.timer.getTime();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.timeLate = gapTo < timeNow ? timeNow - gapTo : 0L;
        this.timeThen = timeNow;
    }

    @Override
    public void run() {
        this.initInThread();
        do {
            this.listener.update();
            if (this.frameRate <= 0) continue;
            this.sync(this.frameRate);
        } while (!this.needClose.get());
        this.deinitInThread();
        logger.fine("NullContext destroyed.");
    }

    @Override
    public void destroy(boolean waitFor) {
        this.needClose.set(true);
        if (waitFor) {
            this.waitFor(false);
        }
    }

    @Override
    public void create(boolean waitFor) {
        if (this.created.get()) {
            logger.warning("create() called when NullContext is already created!");
            return;
        }
        new Thread((Runnable)this, THREAD_NAME).start();
        if (waitFor) {
            this.waitFor(true);
        }
    }

    @Override
    public void restart() {
    }

    @Override
    public void setAutoFlushFrames(boolean enabled) {
    }

    @Override
    public MouseInput getMouseInput() {
        return new DummyMouseInput();
    }

    @Override
    public KeyInput getKeyInput() {
        return new DummyKeyInput();
    }

    @Override
    public JoyInput getJoyInput() {
        return null;
    }

    @Override
    public TouchInput getTouchInput() {
        return null;
    }

    @Override
    public void setTitle(String title) {
    }

    public void create() {
        this.create(false);
    }

    public void destroy() {
        this.destroy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor(boolean createdVal) {
        Object object = this.createdLock;
        synchronized (object) {
            while (this.created.get() != createdVal) {
                try {
                    this.createdLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public boolean isCreated() {
        return this.created.get();
    }

    @Override
    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        this.frameRate = settings.getFrameRate();
        if (this.frameRate <= 0) {
            this.frameRate = 60;
        }
    }

    @Override
    public AppSettings getSettings() {
        return this.settings;
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public boolean isRenderable() {
        return true;
    }

    @Override
    public Context getOpenCLContext() {
        return null;
    }

    @Override
    public int getFramebufferHeight() {
        throw new UnsupportedOperationException("null context");
    }

    @Override
    public int getFramebufferWidth() {
        throw new UnsupportedOperationException("null context");
    }

    @Override
    public int getWindowXPosition() {
        throw new UnsupportedOperationException("null context");
    }

    @Override
    public int getWindowYPosition() {
        throw new UnsupportedOperationException("null context");
    }

    @Override
    public Displays getDisplays() {
        return null;
    }

    @Override
    public int getPrimaryDisplay() {
        return 0;
    }
}

