/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.bufferobject.layout;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.shader.bufferobject.layout.BufferLayout;
import java.nio.ByteBuffer;

public class RawLayout
extends BufferLayout {
    public RawLayout() {
        this.registerSerializer(new BufferLayout.ObjectSerializer<byte[]>(byte[].class){

            @Override
            public int length(BufferLayout serializer, byte[] obj) {
                return obj.length;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, byte[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, byte[] obj) {
                bbf.put(obj);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Integer>(Integer.class){

            @Override
            public int length(BufferLayout serializer, Integer obj) {
                return 4;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Integer obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Integer obj) {
                bbf.putInt(obj);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Boolean>(Boolean.class){

            @Override
            public int length(BufferLayout serializer, Boolean obj) {
                return 4;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Boolean obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Boolean obj) {
                bbf.putInt(obj != false ? 1 : 0);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Float>(Float.class){

            @Override
            public int length(BufferLayout serializer, Float obj) {
                return 4;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Float obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Float obj) {
                bbf.putFloat(obj.floatValue());
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Vector2f>(Vector2f.class){

            @Override
            public int length(BufferLayout serializer, Vector2f obj) {
                return 8;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Vector2f obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Vector2f obj) {
                bbf.putFloat(obj.x);
                bbf.putFloat(obj.y);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<ColorRGBA>(ColorRGBA.class){

            @Override
            public int length(BufferLayout serializer, ColorRGBA obj) {
                return 16;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, ColorRGBA obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, ColorRGBA obj) {
                bbf.putFloat(obj.r);
                bbf.putFloat(obj.g);
                bbf.putFloat(obj.b);
                bbf.putFloat(obj.a);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Quaternion>(Quaternion.class){

            @Override
            public int length(BufferLayout serializer, Quaternion obj) {
                return 16;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Quaternion obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Quaternion obj) {
                bbf.putFloat(obj.getX());
                bbf.putFloat(obj.getY());
                bbf.putFloat(obj.getZ());
                bbf.putFloat(obj.getW());
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Vector4f>(Vector4f.class){

            @Override
            public int length(BufferLayout serializer, Vector4f obj) {
                return 16;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Vector4f obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Vector4f obj) {
                bbf.putFloat(obj.x);
                bbf.putFloat(obj.y);
                bbf.putFloat(obj.z);
                bbf.putFloat(obj.w);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Vector3f>(Vector3f.class){

            @Override
            public int length(BufferLayout serializer, Vector3f obj) {
                return 12;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Vector3f obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Vector3f obj) {
                bbf.putFloat(obj.x);
                bbf.putFloat(obj.y);
                bbf.putFloat(obj.z);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Integer[]>(Integer[].class){

            @Override
            public int length(BufferLayout serializer, Integer[] obj) {
                return 4 * obj.length;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Integer[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Integer[] obj) {
                Integer[] integerArray = obj;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int i2 = integerArray[i];
                    bbf.putInt(i2);
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Float[]>(Float[].class){

            @Override
            public int length(BufferLayout serializer, Float[] obj) {
                return 4 * obj.length;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Float[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Float[] obj) {
                Float[] floatArray = obj;
                int n = floatArray.length;
                for (int i = 0; i < n; ++i) {
                    float i2 = floatArray[i].floatValue();
                    bbf.putFloat(i2);
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Boolean[]>(Boolean[].class){

            @Override
            public int length(BufferLayout serializer, Boolean[] obj) {
                return 4 * obj.length;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Boolean[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Boolean[] obj) {
                Boolean[] booleanArray = obj;
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean i2 = booleanArray[i];
                    bbf.putInt(i2 ? 1 : 0);
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Vector2f[]>(Vector2f[].class){

            @Override
            public int length(BufferLayout serializer, Vector2f[] obj) {
                return 4 * obj.length * 2;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Vector2f[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Vector2f[] obj) {
                for (Vector2f i : obj) {
                    bbf.putFloat(i.x);
                    bbf.putFloat(i.y);
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Vector3f[]>(Vector3f[].class){

            @Override
            public int length(BufferLayout serializer, Vector3f[] obj) {
                return 4 * obj.length * 3;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Vector3f[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Vector3f[] obj) {
                for (Vector3f i : obj) {
                    bbf.putFloat(i.x);
                    bbf.putFloat(i.y);
                    bbf.putFloat(i.z);
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Vector4f[]>(Vector4f[].class){

            @Override
            public int length(BufferLayout serializer, Vector4f[] obj) {
                return 4 * obj.length * 4;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Vector4f[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Vector4f[] obj) {
                for (Vector4f i : obj) {
                    bbf.putFloat(i.x);
                    bbf.putFloat(i.y);
                    bbf.putFloat(i.z);
                    bbf.putFloat(i.w);
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<ColorRGBA[]>(ColorRGBA[].class){

            @Override
            public int length(BufferLayout serializer, ColorRGBA[] obj) {
                return 4 * obj.length * 4;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, ColorRGBA[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, ColorRGBA[] obj) {
                for (ColorRGBA i : obj) {
                    bbf.putFloat(i.r);
                    bbf.putFloat(i.g);
                    bbf.putFloat(i.b);
                    bbf.putFloat(i.a);
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Quaternion[]>(Quaternion[].class){

            @Override
            public int length(BufferLayout serializer, Quaternion[] obj) {
                return 4 * obj.length * 4;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Quaternion[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Quaternion[] obj) {
                for (Quaternion i : obj) {
                    bbf.putFloat(i.getX());
                    bbf.putFloat(i.getY());
                    bbf.putFloat(i.getZ());
                    bbf.putFloat(i.getW());
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Matrix3f>(Matrix3f.class){
            final Vector3f tmp;
            {
                this.tmp = new Vector3f();
            }

            @Override
            public int length(BufferLayout serializer, Matrix3f obj) {
                return 36;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Matrix3f obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Matrix3f obj) {
                obj.getColumn(0, this.tmp);
                bbf.putFloat(this.tmp.x);
                bbf.putFloat(this.tmp.y);
                bbf.putFloat(this.tmp.z);
                obj.getColumn(1, this.tmp);
                bbf.putFloat(this.tmp.x);
                bbf.putFloat(this.tmp.y);
                bbf.putFloat(this.tmp.z);
                obj.getColumn(2, this.tmp);
                bbf.putFloat(this.tmp.x);
                bbf.putFloat(this.tmp.y);
                bbf.putFloat(this.tmp.z);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Matrix4f>(Matrix4f.class){
            final float[] tmpF;
            {
                this.tmpF = new float[4];
            }

            @Override
            public int length(BufferLayout serializer, Matrix4f obj) {
                return 64;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Matrix4f obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Matrix4f obj) {
                obj.getColumn(0, this.tmpF);
                bbf.putFloat(this.tmpF[0]);
                bbf.putFloat(this.tmpF[1]);
                bbf.putFloat(this.tmpF[2]);
                bbf.putFloat(this.tmpF[3]);
                obj.getColumn(1, this.tmpF);
                bbf.putFloat(this.tmpF[0]);
                bbf.putFloat(this.tmpF[1]);
                bbf.putFloat(this.tmpF[2]);
                bbf.putFloat(this.tmpF[3]);
                obj.getColumn(2, this.tmpF);
                bbf.putFloat(this.tmpF[0]);
                bbf.putFloat(this.tmpF[1]);
                bbf.putFloat(this.tmpF[2]);
                bbf.putFloat(this.tmpF[3]);
                obj.getColumn(3, this.tmpF);
                bbf.putFloat(this.tmpF[0]);
                bbf.putFloat(this.tmpF[1]);
                bbf.putFloat(this.tmpF[2]);
                bbf.putFloat(this.tmpF[3]);
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Matrix3f[]>(Matrix3f[].class){
            final Vector3f tmp;
            {
                this.tmp = new Vector3f();
            }

            @Override
            public int length(BufferLayout serializer, Matrix3f[] obj) {
                return 36 * obj.length;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Matrix3f[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Matrix3f[] objs) {
                for (Matrix3f obj : objs) {
                    obj.getColumn(0, this.tmp);
                    bbf.putFloat(this.tmp.x);
                    bbf.putFloat(this.tmp.y);
                    bbf.putFloat(this.tmp.z);
                    obj.getColumn(1, this.tmp);
                    bbf.putFloat(this.tmp.x);
                    bbf.putFloat(this.tmp.y);
                    bbf.putFloat(this.tmp.z);
                    obj.getColumn(2, this.tmp);
                    bbf.putFloat(this.tmp.x);
                    bbf.putFloat(this.tmp.y);
                    bbf.putFloat(this.tmp.z);
                }
            }
        });
        this.registerSerializer(new BufferLayout.ObjectSerializer<Matrix4f[]>(Matrix4f[].class){
            final float[] tmpF;
            {
                this.tmpF = new float[4];
            }

            @Override
            public int length(BufferLayout serializer, Matrix4f[] obj) {
                return 64 * obj.length;
            }

            @Override
            public int basicAlignment(BufferLayout serializer, Matrix4f[] obj) {
                return 1;
            }

            @Override
            public void write(BufferLayout serializer, ByteBuffer bbf, Matrix4f[] objs) {
                for (Matrix4f obj : objs) {
                    obj.getColumn(0, this.tmpF);
                    bbf.putFloat(this.tmpF[0]);
                    bbf.putFloat(this.tmpF[1]);
                    bbf.putFloat(this.tmpF[2]);
                    bbf.putFloat(this.tmpF[3]);
                    obj.getColumn(1, this.tmpF);
                    bbf.putFloat(this.tmpF[0]);
                    bbf.putFloat(this.tmpF[1]);
                    bbf.putFloat(this.tmpF[2]);
                    bbf.putFloat(this.tmpF[3]);
                    obj.getColumn(2, this.tmpF);
                    bbf.putFloat(this.tmpF[0]);
                    bbf.putFloat(this.tmpF[1]);
                    bbf.putFloat(this.tmpF[2]);
                    bbf.putFloat(this.tmpF[3]);
                    obj.getColumn(3, this.tmpF);
                    bbf.putFloat(this.tmpF[0]);
                    bbf.putFloat(this.tmpF[1]);
                    bbf.putFloat(this.tmpF[2]);
                    bbf.putFloat(this.tmpF[3]);
                }
            }
        });
    }

    @Override
    public String getId() {
        return "raw";
    }
}

