/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.bufferobject;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.shader.bufferobject.BufferObject;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BufferRegion
implements Savable,
Cloneable {
    protected int start = -1;
    protected int end = -1;
    protected boolean dirty = true;
    protected boolean fullBufferRegion = false;
    protected BufferObject bo;
    protected ByteBuffer slice;
    protected ByteBuffer source;

    public BufferRegion(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public BufferRegion() {
    }

    public ByteBuffer getData() {
        ByteBuffer d = this.bo.getData();
        if (this.source == null || d != this.source || this.slice == null) {
            this.source = d;
            int currentPos = this.source.position();
            int currentLimit = this.source.limit();
            assert (this.end < this.source.capacity()) : "Can't set limit at " + this.end + " on capacity " + this.source.capacity();
            this.source.limit(this.end + 1);
            this.source.position(this.start);
            this.slice = this.source.slice();
            this.slice.order(this.source.order());
            assert (this.slice.limit() == this.end - this.start + 1) : "Capacity is " + this.slice.limit() + " but " + (this.end - this.start + 1) + " expected";
            this.source.limit(currentLimit);
            this.source.position(currentPos);
        }
        this.slice.rewind();
        return this.slice;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int length() {
        return this.end - this.start + 1;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public boolean isFullBufferRegion() {
        return this.fullBufferRegion;
    }

    public String toString() {
        return "Region [start=" + this.start + ", end=" + this.end + ", size=" + (this.end - this.start) + ", dirty=" + this.dirty + "]";
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.start, "start", 0);
        oc.write(this.end, "end", 0);
        oc.write(this.dirty, "dirty", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.start = ic.readInt("start", 0);
        this.end = ic.readInt("end", 0);
        this.dirty = ic.readBoolean("dirty", false);
    }

    public BufferRegion clone() {
        try {
            return (BufferRegion)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

