/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Iterator;
import java.util.LinkedList;

public class SceneGraphIterator
implements Iterable<Spatial>,
Iterator<Spatial> {
    private Spatial current;
    private Spatial main;
    private int depth = 0;
    private final LinkedList<PathNode> path = new LinkedList();

    public SceneGraphIterator(Spatial main) {
        if (main instanceof Node) {
            this.path.add(new PathNode((Node)main));
            ++this.depth;
        }
        this.main = main;
    }

    @Override
    public Iterator<Spatial> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.main != null) {
            return true;
        }
        this.trim();
        return !this.path.isEmpty();
    }

    @Override
    public Spatial next() {
        if (this.main != null) {
            this.current = this.main;
            this.main = null;
        } else {
            Node n;
            this.current = this.path.getLast().iterator.next();
            if (this.current instanceof Node && !(n = (Node)this.current).getChildren().isEmpty()) {
                this.path.addLast(new PathNode(n));
                ++this.depth;
            }
        }
        return this.current;
    }

    public Spatial current() {
        return this.current;
    }

    public void ignoreChildren() {
        if (this.current instanceof Node) {
            this.path.removeLast();
            --this.depth;
        }
    }

    public int getDepth() {
        return !this.path.isEmpty() && this.current == this.path.getLast().node ? this.depth - 1 : this.depth;
    }

    private void trim() {
        if (!this.path.isEmpty() && !this.path.getLast().iterator.hasNext()) {
            this.path.removeLast();
            --this.depth;
            this.trim();
        }
    }

    private static class PathNode {
        Node node;
        Iterator<Spatial> iterator;

        PathNode(Node node) {
            this.node = node;
            this.iterator = this.node.getChildren().iterator();
        }
    }
}

