/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.queue;

import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.GuiComparator;
import com.jme3.renderer.queue.NullComparator;
import com.jme3.renderer.queue.OpaqueComparator;
import com.jme3.renderer.queue.TransparentComparator;
import com.jme3.scene.Geometry;

public class RenderQueue {
    private GeometryList opaqueList = new GeometryList(new OpaqueComparator());
    private GeometryList guiList = new GeometryList(new GuiComparator());
    private GeometryList transparentList = new GeometryList(new TransparentComparator());
    private GeometryList translucentList = new GeometryList(new TransparentComparator());
    private GeometryList skyList = new GeometryList(new NullComparator());

    public void setGeometryComparator(Bucket bucket, GeometryComparator c) {
        switch (bucket.ordinal()) {
            case 4: {
                this.guiList = new GeometryList(c);
                break;
            }
            case 0: {
                this.opaqueList = new GeometryList(c);
                break;
            }
            case 2: {
                this.skyList = new GeometryList(c);
                break;
            }
            case 1: {
                this.transparentList = new GeometryList(c);
                break;
            }
            case 3: {
                this.translucentList = new GeometryList(c);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown bucket type: " + (Object)((Object)bucket));
            }
        }
    }

    public GeometryComparator getGeometryComparator(Bucket bucket) {
        switch (bucket.ordinal()) {
            case 4: {
                return this.guiList.getComparator();
            }
            case 0: {
                return this.opaqueList.getComparator();
            }
            case 2: {
                return this.skyList.getComparator();
            }
            case 1: {
                return this.transparentList.getComparator();
            }
            case 3: {
                return this.translucentList.getComparator();
            }
        }
        throw new UnsupportedOperationException("Unknown bucket type: " + (Object)((Object)bucket));
    }

    public void addToQueue(Geometry g, Bucket bucket) {
        switch (bucket.ordinal()) {
            case 4: {
                this.guiList.add(g);
                break;
            }
            case 0: {
                this.opaqueList.add(g);
                break;
            }
            case 2: {
                this.skyList.add(g);
                break;
            }
            case 1: {
                this.transparentList.add(g);
                break;
            }
            case 3: {
                this.translucentList.add(g);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown bucket type: " + (Object)((Object)bucket));
            }
        }
    }

    private void renderGeometryList(GeometryList list, RenderManager rm, Camera cam, boolean flush) {
        list.setCamera(cam);
        list.sort();
        for (int i = 0; i < list.size(); ++i) {
            Geometry obj = list.get(i);
            assert (obj != null);
            rm.renderGeometry(obj);
            obj.queueDistance = Float.NEGATIVE_INFINITY;
        }
        if (flush) {
            list.clear();
        }
    }

    public void renderShadowQueue(GeometryList list, RenderManager rm, Camera cam, boolean clear) {
        rm.getRenderer().pushDebugGroup("ShadowQueue");
        this.renderGeometryList(list, rm, cam, clear);
        rm.getRenderer().popDebugGroup();
    }

    public boolean isQueueEmpty(Bucket bucket) {
        switch (bucket.ordinal()) {
            case 4: {
                return this.guiList.size() == 0;
            }
            case 0: {
                return this.opaqueList.size() == 0;
            }
            case 2: {
                return this.skyList.size() == 0;
            }
            case 1: {
                return this.transparentList.size() == 0;
            }
            case 3: {
                return this.translucentList.size() == 0;
            }
        }
        throw new UnsupportedOperationException("Unsupported bucket type: " + (Object)((Object)bucket));
    }

    public void renderQueue(Bucket bucket, RenderManager rm, Camera cam) {
        this.renderQueue(bucket, rm, cam, true);
    }

    public void renderQueue(Bucket bucket, RenderManager rm, Camera cam, boolean clear) {
        rm.getRenderer().pushDebugGroup(bucket.name());
        switch (bucket.ordinal()) {
            case 4: {
                this.renderGeometryList(this.guiList, rm, cam, clear);
                break;
            }
            case 0: {
                this.renderGeometryList(this.opaqueList, rm, cam, clear);
                break;
            }
            case 2: {
                this.renderGeometryList(this.skyList, rm, cam, clear);
                break;
            }
            case 1: {
                this.renderGeometryList(this.transparentList, rm, cam, clear);
                break;
            }
            case 3: {
                this.renderGeometryList(this.translucentList, rm, cam, clear);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported bucket type: " + (Object)((Object)bucket));
            }
        }
        rm.getRenderer().popDebugGroup();
    }

    public GeometryList getList(Bucket bucket) {
        switch (bucket.ordinal()) {
            case 0: {
                return this.opaqueList;
            }
            case 4: {
                return this.guiList;
            }
            case 1: {
                return this.transparentList;
            }
            case 3: {
                return this.translucentList;
            }
            case 2: {
                return this.skyList;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.opaqueList.clear();
        this.guiList.clear();
        this.transparentList.clear();
        this.translucentList.clear();
        this.skyList.clear();
    }

    public static enum Bucket {
        Opaque,
        Transparent,
        Sky,
        Translucent,
        Gui,
        Inherit;

    }

    public static enum ShadowMode {
        Off,
        Cast,
        Receive,
        CastAndReceive,
        Inherit;

    }
}

