/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.AssetManager;
import com.jme3.light.LightList;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.material.TechniqueDef;
import com.jme3.material.logic.TechniqueDefLogic;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.VarType;
import com.jme3.util.ListMap;
import com.jme3.util.SafeArrayList;
import java.util.EnumSet;

public final class Technique {
    private final TechniqueDef def;
    private final Material owner;
    private final DefineList paramDefines;
    private final DefineList dynamicDefines;

    public Technique(Material owner, TechniqueDef def) {
        this.owner = owner;
        this.def = def;
        this.paramDefines = def.createDefineList();
        this.dynamicDefines = def.createDefineList();
    }

    public TechniqueDef getDef() {
        return this.def;
    }

    final void notifyParamChanged(String paramName, VarType type, Object value) {
        Integer defineId = this.def.getShaderParamDefineId(paramName);
        if (defineId == null) {
            return;
        }
        this.paramDefines.set(defineId, type, value);
    }

    final void notifyTechniqueSwitched() {
        ListMap<String, MatParam> paramMap = this.owner.getParamsMap();
        this.paramDefines.clear();
        for (int i = 0; i < paramMap.size(); ++i) {
            MatParam param = paramMap.getValue(i);
            this.notifyParamChanged(param.getName(), param.getVarType(), param.getValue());
        }
    }

    private void applyOverrides(DefineList defineList, SafeArrayList<MatParamOverride> overrides) {
        for (MatParamOverride override : overrides.getArray()) {
            Integer defineId;
            if (!override.isEnabled() || (defineId = this.def.getShaderParamDefineId(override.name)) == null || this.def.getDefineIdType(defineId) != override.type) continue;
            defineList.set(defineId, override.type, override.value);
        }
    }

    Shader makeCurrent(RenderManager renderManager, SafeArrayList<MatParamOverride> worldOverrides, SafeArrayList<MatParamOverride> forcedOverrides, LightList lights, EnumSet<Caps> rendererCaps) {
        TechniqueDefLogic logic = this.def.getLogic();
        AssetManager assetManager = this.owner.getMaterialDef().getAssetManager();
        this.dynamicDefines.clear();
        this.dynamicDefines.setAll(this.paramDefines);
        if (worldOverrides != null) {
            this.applyOverrides(this.dynamicDefines, worldOverrides);
        }
        if (forcedOverrides != null) {
            this.applyOverrides(this.dynamicDefines, forcedOverrides);
        }
        return logic.makeCurrent(assetManager, renderManager, rendererCaps, lights, this.dynamicDefines);
    }

    void render(RenderManager renderManager, Shader shader, Geometry geometry, LightList lights, Material.BindUnits lastBindUnits) {
        TechniqueDefLogic logic = this.def.getLogic();
        logic.render(renderManager, shader, geometry, lights, lastBindUnits);
    }

    public DefineList getDynamicDefines() {
        return this.dynamicDefines;
    }

    @Deprecated
    public DefineList getAllDefines() {
        throw new UnsupportedOperationException();
    }

    public int getSortId() {
        int hash = 17;
        hash = hash * 23 + this.def.getSortId();
        hash = hash * 23 + this.paramDefines.hashCode();
        return hash;
    }
}

