/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment.baker;

import com.jme3.asset.AssetManager;
import com.jme3.environment.baker.GenericEnvBaker;
import com.jme3.environment.baker.IBLEnvBakerLight;
import com.jme3.environment.util.EnvMapUtils;
import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.image.ColorSpace;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IBLHybridEnvBakerLight
extends GenericEnvBaker
implements IBLEnvBakerLight {
    private static final Logger LOGGER = Logger.getLogger(IBLHybridEnvBakerLight.class.getName());
    protected TextureCubeMap specular;
    protected Vector3f[] shCoef;

    public IBLHybridEnvBakerLight(RenderManager rm, AssetManager am, Image.Format format, Image.Format depthFormat, int env_size, int specular_size) {
        super(rm, am, format, depthFormat, env_size);
        this.specular = new TextureCubeMap(specular_size, specular_size, format);
        this.specular.setWrap(Texture.WrapMode.EdgeClamp);
        this.specular.setMagFilter(Texture.MagFilter.Bilinear);
        this.specular.setMinFilter(Texture.MinFilter.Trilinear);
        this.specular.getImage().setColorSpace(ColorSpace.Linear);
        int nbMipMaps = (int)(Math.log(specular_size) / Math.log(2.0) + 1.0);
        nbMipMaps = this.limitMips(nbMipMaps, this.specular.getImage().getWidth(), this.specular.getImage().getHeight(), rm);
        int[] sizes = new int[nbMipMaps];
        for (int i = 0; i < nbMipMaps; ++i) {
            int size = (int)FastMath.pow(2.0f, nbMipMaps - 1 - i);
            sizes[i] = size * size * (this.specular.getImage().getFormat().getBitsPerPixel() / 8);
        }
        this.specular.getImage().setMipMapSizes(sizes);
        this.specular.getImage().setMipmapsGenerated(true);
    }

    @Override
    public boolean isTexturePulling() {
        return true;
    }

    private void bakeSpecularIBL(int mip, float roughness, Material mat, Geometry screen) throws Exception {
        int i;
        mat.setFloat("Roughness", roughness);
        int mipWidth = (int)((float)this.specular.getImage().getWidth() * FastMath.pow(0.5f, mip));
        int mipHeight = (int)((float)this.specular.getImage().getHeight() * FastMath.pow(0.5f, mip));
        FrameBuffer[] specularbakers = new FrameBuffer[6];
        for (i = 0; i < 6; ++i) {
            specularbakers[i] = new FrameBuffer(mipWidth, mipHeight, 1);
            specularbakers[i].setSrgb(false);
            specularbakers[i].addColorTarget(FrameBuffer.FrameBufferTarget.newTarget(this.specular).level(mip).face(i));
            specularbakers[i].setMipMapsGenerationHint(false);
        }
        for (i = 0; i < 6; ++i) {
            FrameBuffer specularbaker = specularbakers[i];
            mat.setInt("FaceId", i);
            screen.updateLogicalState(0.0f);
            screen.updateGeometricState();
            this.renderManager.setCamera(this.updateAndGetInternalCamera(i, specularbaker.getWidth(), specularbaker.getHeight(), Vector3f.ZERO, 1.0f, 1000.0f), false);
            this.renderManager.getRenderer().setFrameBuffer(specularbaker);
            this.renderManager.renderGeometry(screen);
            if (!this.isTexturePulling()) continue;
            this.pull(specularbaker, this.specular, i);
        }
        for (i = 0; i < 6; ++i) {
            specularbakers[i].dispose();
        }
    }

    @Override
    public void bakeSpecularIBL() {
        int mip;
        Box boxm = new Box(1.0f, 1.0f, 1.0f);
        Geometry screen = new Geometry("BakeBox", boxm);
        Material mat = new Material(this.assetManager, "Common/IBL/IBLKernels.j3md");
        mat.setBoolean("UseSpecularIBL", true);
        mat.setTexture("EnvMap", this.envMap);
        screen.setMaterial(mat);
        if (this.isTexturePulling()) {
            this.startPulling();
        }
        for (mip = 0; mip < this.specular.getImage().getMipMapSizes().length; ++mip) {
            try {
                float roughness = (float)mip / (float)(this.specular.getImage().getMipMapSizes().length - 1);
                this.bakeSpecularIBL(mip, roughness, mat, screen);
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error while computing mip level " + mip, e);
                break;
            }
        }
        if (mip < this.specular.getImage().getMipMapSizes().length) {
            int[] sizes = this.specular.getImage().getMipMapSizes();
            sizes = Arrays.copyOf(sizes, mip);
            this.specular.getImage().setMipMapSizes(sizes);
            this.specular.getImage().setMipmapsGenerated(true);
            if (sizes.length <= 1) {
                try {
                    LOGGER.log(Level.WARNING, "Workaround driver BUG: only one mip level available, regenerate it with higher roughness (shiny fix)");
                    this.bakeSpecularIBL(0, 1.0f, mat, screen);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Error while recomputing mip level 0", e);
                }
            }
        }
        if (this.isTexturePulling()) {
            this.endPulling(this.specular);
        }
        this.specular.getImage().clearUpdateNeeded();
    }

    @Override
    public TextureCubeMap getSpecularIBL() {
        return this.specular;
    }

    @Override
    public void bakeSphericalHarmonicsCoefficients() {
        this.shCoef = EnvMapUtils.getSphericalHarmonicsCoefficents(this.getEnvMap());
    }

    @Override
    public Vector3f[] getSphericalHarmonicsCoefficients() {
        return this.shCoef;
    }
}

