/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment;

import com.jme3.asset.AssetManager;
import com.jme3.environment.baker.IBLGLEnvBakerLight;
import com.jme3.environment.baker.IBLHybridEnvBakerLight;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.LightProbe;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.texture.Image;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class EnvironmentProbeControl
extends LightProbe
implements Control {
    private static AtomicInteger instanceCounter = new AtomicInteger(0);
    private AssetManager assetManager;
    private boolean bakeNeeded = true;
    private int envMapSize = 256;
    private Spatial spatial;
    private boolean requiredSavableResults = false;
    private float frustumNear = 0.001f;
    private float frustumFar = 1000.0f;
    private String uuid = "none";
    private boolean enabled = true;
    private Predicate<Geometry> filter = s -> s.getUserData("tags.env") != null || s.getUserData("tags.env.env" + this.uuid) != null;

    protected EnvironmentProbeControl() {
        this.uuid = System.currentTimeMillis() + "_" + instanceCounter.getAndIncrement();
        this.setAreaType(LightProbe.AreaType.Spherical);
        this.getArea().setRadius(Float.MAX_VALUE);
    }

    public EnvironmentProbeControl(AssetManager assetManager, int size) {
        this();
        this.envMapSize = size;
        this.assetManager = assetManager;
    }

    public void tag(Spatial s) {
        if (s instanceof Node) {
            Node n = (Node)s;
            for (Spatial sx : n.getChildren()) {
                this.tag(sx);
            }
        } else if (s instanceof Geometry) {
            s.setUserData("tags.env.env" + this.uuid, true);
        }
    }

    public void untag(Spatial s) {
        if (s instanceof Node) {
            Node n = (Node)s;
            for (Spatial sx : n.getChildren()) {
                this.untag(sx);
            }
        } else if (s instanceof Geometry) {
            s.setUserData("tags.env.env" + this.uuid, null);
        }
    }

    public static void tagGlobal(Spatial s) {
        if (s instanceof Node) {
            Node n = (Node)s;
            for (Spatial sx : n.getChildren()) {
                EnvironmentProbeControl.tagGlobal(sx);
            }
        } else if (s instanceof Geometry) {
            s.setUserData("tags.env", true);
        }
    }

    public static void untagGlobal(Spatial s) {
        if (s instanceof Node) {
            Node n = (Node)s;
            for (Spatial sx : n.getChildren()) {
                EnvironmentProbeControl.untagGlobal(sx);
            }
        } else if (s instanceof Geometry) {
            s.setUserData("tags.env", null);
        }
    }

    @Override
    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException();
    }

    public void setRequiredSavableResults(boolean v) {
        this.requiredSavableResults = v;
    }

    public boolean isRequiredSavableResults() {
        return this.requiredSavableResults;
    }

    @Override
    public void setSpatial(Spatial spatial) {
        if (this.spatial != null && spatial != null && spatial != this.spatial) {
            throw new IllegalStateException("This control has already been added to a Spatial");
        }
        this.spatial = spatial;
        if (spatial != null) {
            spatial.addLight(this);
        }
    }

    @Override
    public void update(float tpf) {
    }

    @Override
    public void render(RenderManager rm, ViewPort vp) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.bakeNeeded) {
            this.bakeNeeded = false;
            this.rebakeNow(rm);
        }
    }

    public void rebake() {
        this.bakeNeeded = true;
    }

    public void setFrustumNear(float frustumNear) {
        this.frustumNear = frustumNear;
    }

    public void setFrustumFar(float frustumFar) {
        this.frustumFar = frustumFar;
    }

    public float getFrustumNear() {
        return this.frustumNear;
    }

    public float getFrustumFar() {
        return this.frustumFar;
    }

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    void rebakeNow(RenderManager renderManager) {
        IBLGLEnvBakerLight baker = new IBLGLEnvBakerLight(renderManager, this.assetManager, Image.Format.RGB16F, Image.Format.Depth, this.envMapSize, this.envMapSize);
        baker.setTexturePulling(this.isRequiredSavableResults());
        baker.bakeEnvironment(this.spatial, this.getPosition(), this.frustumNear, this.frustumFar, this.filter);
        baker.bakeSpecularIBL();
        ((IBLHybridEnvBakerLight)baker).bakeSphericalHarmonicsCoefficients();
        this.setPrefilteredMap(baker.getSpecularIBL());
        int[] mipSizes = this.getPrefilteredEnvMap().getImage().getMipMapSizes();
        this.setNbMipMaps(mipSizes != null ? mipSizes.length : 1);
        this.setShCoeffs(baker.getSphericalHarmonicsCoefficients());
        this.setPosition(Vector3f.ZERO);
        this.setReady(true);
        baker.clean();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.spatial, "spatial", null);
        oc.write(this.envMapSize, "size", 256);
        oc.write(this.requiredSavableResults, "requiredSavableResults", false);
        oc.write(this.bakeNeeded, "bakeNeeded", true);
        oc.write(this.frustumFar, "frustumFar", 1000.0f);
        oc.write(this.frustumNear, "frustumNear", 0.001f);
        oc.write(this.uuid, "envProbeControlUUID", "none");
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.enabled = ic.readBoolean("enabled", true);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
        this.envMapSize = ic.readInt("size", 256);
        this.requiredSavableResults = ic.readBoolean("requiredSavableResults", false);
        this.bakeNeeded = ic.readBoolean("bakeNeeded", true);
        this.assetManager = im.getAssetManager();
        this.frustumFar = ic.readFloat("frustumFar", 1000.0f);
        this.frustumNear = ic.readFloat("frustumNear", 0.001f);
        this.uuid = ic.readString("envProbeControlUUID", "none");
    }
}

