/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.collision.bih;

import com.jme3.bounding.BoundingBox;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.bih.BIHTree;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix4f;
import com.jme3.math.Ray;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.ArrayList;

public final class BIHNode
implements Savable {
    private int leftIndex;
    private int rightIndex;
    private BIHNode left;
    private BIHNode right;
    private float leftPlane;
    private float rightPlane;
    private int axis;

    public BIHNode(int l, int r) {
        this.leftIndex = l;
        this.rightIndex = r;
        this.axis = 3;
    }

    public BIHNode(int axis) {
        this.axis = axis;
    }

    public BIHNode() {
    }

    public BIHNode getLeftChild() {
        return this.left;
    }

    public void setLeftChild(BIHNode left) {
        this.left = left;
    }

    public float getLeftPlane() {
        return this.leftPlane;
    }

    public void setLeftPlane(float leftPlane) {
        this.leftPlane = leftPlane;
    }

    public BIHNode getRightChild() {
        return this.right;
    }

    public void setRightChild(BIHNode right) {
        this.right = right;
    }

    public float getRightPlane() {
        return this.rightPlane;
    }

    public void setRightPlane(float rightPlane) {
        this.rightPlane = rightPlane;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.leftIndex, "left_index", 0);
        oc.write(this.rightIndex, "right_index", 0);
        oc.write(this.leftPlane, "left_plane", 0.0f);
        oc.write(this.rightPlane, "right_plane", 0.0f);
        oc.write(this.axis, "axis", 0);
        oc.write(this.left, "left_node", null);
        oc.write(this.right, "right_node", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.leftIndex = ic.readInt("left_index", 0);
        this.rightIndex = ic.readInt("right_index", 0);
        this.leftPlane = ic.readFloat("left_plane", 0.0f);
        this.rightPlane = ic.readFloat("right_plane", 0.0f);
        this.axis = ic.readInt("axis", 0);
        this.left = (BIHNode)ic.readSavable("left_node", null);
        this.right = (BIHNode)ic.readSavable("right_node", null);
    }

    public final int intersectWhere(Collidable col, BoundingBox box, Matrix4f worldMatrix, BIHTree tree, CollisionResults results) {
        TempVars vars = TempVars.get();
        ArrayList<BIHStackData> stack = vars.bihStack;
        stack.clear();
        float[] minExts = new float[]{box.getCenter().x - box.getXExtent(), box.getCenter().y - box.getYExtent(), box.getCenter().z - box.getZExtent()};
        float[] maxExts = new float[]{box.getCenter().x + box.getXExtent(), box.getCenter().y + box.getYExtent(), box.getCenter().z + box.getZExtent()};
        stack.add(new BIHStackData(this, 0.0f, 0.0f));
        Triangle t = new Triangle();
        int cols = 0;
        block0: while (stack.size() > 0) {
            BIHNode node = stack.remove(stack.size() - 1).node;
            while (node.axis != 3) {
                int a = node.axis;
                float maxExt = maxExts[a];
                float minExt = minExts[a];
                if (node.leftPlane < node.rightPlane && minExt > node.leftPlane && maxExt < node.rightPlane) continue block0;
                if (maxExt < node.rightPlane) {
                    node = node.left;
                    continue;
                }
                if (minExt > node.leftPlane) {
                    node = node.right;
                    continue;
                }
                stack.add(new BIHStackData(node.right, 0.0f, 0.0f));
                node = node.left;
            }
            for (int i = node.leftIndex; i <= node.rightIndex; ++i) {
                int start;
                int added;
                tree.getTriangle(i, t.get1(), t.get2(), t.get3());
                if (worldMatrix != null) {
                    worldMatrix.mult(t.get1(), t.get1());
                    worldMatrix.mult(t.get2(), t.get2());
                    worldMatrix.mult(t.get3(), t.get3());
                }
                if ((added = col.collideWith(t, results)) <= 0) continue;
                int index = tree.getTriangleIndex(i);
                for (int j = start = results.size() - added; j < results.size(); ++j) {
                    CollisionResult cr = results.getCollisionDirect(j);
                    cr.setTriangleIndex(index);
                }
                cols += added;
            }
        }
        vars.release();
        return cols;
    }

    public final int intersectBrute(Ray r, Matrix4f worldMatrix, BIHTree tree, float sceneMin, float sceneMax, CollisionResults results) {
        float tHit = Float.POSITIVE_INFINITY;
        TempVars vars = TempVars.get();
        Vector3f v1 = vars.vect1;
        Vector3f v2 = vars.vect2;
        Vector3f v3 = vars.vect3;
        int cols = 0;
        ArrayList<BIHStackData> stack = vars.bihStack;
        stack.clear();
        stack.add(new BIHStackData(this, 0.0f, 0.0f));
        while (stack.size() > 0) {
            BIHStackData data = stack.remove(stack.size() - 1);
            BIHNode node = data.node;
            while (node.axis != 3) {
                BIHNode nearNode = node.left;
                BIHNode farNode = node.right;
                stack.add(new BIHStackData(farNode, 0.0f, 0.0f));
                node = nearNode;
            }
            for (int i = node.leftIndex; i <= node.rightIndex; ++i) {
                float t;
                tree.getTriangle(i, v1, v2, v3);
                if (worldMatrix != null) {
                    worldMatrix.mult(v1, v1);
                    worldMatrix.mult(v2, v2);
                    worldMatrix.mult(v3, v3);
                }
                if (!((t = r.intersects(v1, v2, v3)) < tHit)) continue;
                tHit = t;
                Vector3f contactPoint = new Vector3f(r.direction).multLocal(tHit).addLocal(r.origin);
                CollisionResult cr = new CollisionResult(contactPoint, tHit);
                cr.setTriangleIndex(tree.getTriangleIndex(i));
                results.addCollision(cr);
                ++cols;
            }
        }
        vars.release();
        return cols;
    }

    public final int intersectWhere(Ray r, Matrix4f worldMatrix, BIHTree tree, float sceneMin, float sceneMax, CollisionResults results) {
        TempVars vars = TempVars.get();
        ArrayList<BIHStackData> stack = vars.bihStack;
        stack.clear();
        Vector3f o = vars.vect1.set(r.getOrigin());
        Vector3f d = vars.vect2.set(r.getDirection());
        Matrix4f inv = vars.tempMat4.set(worldMatrix).invertLocal();
        inv.mult(r.getOrigin(), r.getOrigin());
        inv.multNormal(r.getDirection(), r.getDirection());
        float[] origins = new float[]{r.getOrigin().x, r.getOrigin().y, r.getOrigin().z};
        float[] invDirections = new float[]{1.0f / r.getDirection().x, 1.0f / r.getDirection().y, 1.0f / r.getDirection().z};
        r.getDirection().normalizeLocal();
        Vector3f v1 = vars.vect3;
        Vector3f v2 = vars.vect4;
        Vector3f v3 = vars.vect5;
        int cols = 0;
        stack.add(new BIHStackData(this, sceneMin, sceneMax));
        block0: while (stack.size() > 0) {
            BIHStackData data = stack.remove(stack.size() - 1);
            BIHNode node = data.node;
            float tMin = data.min;
            float tMax = data.max;
            if (tMax < tMin) continue;
            while (node.axis != 3) {
                int a = node.axis;
                float origin = origins[a];
                float invDirection = invDirections[a];
                float tNearSplit = (node.leftPlane - origin) * invDirection;
                float tFarSplit = (node.rightPlane - origin) * invDirection;
                BIHNode nearNode = node.left;
                BIHNode farNode = node.right;
                if (invDirection < 0.0f) {
                    float tmpSplit = tNearSplit;
                    tNearSplit = tFarSplit;
                    tFarSplit = tmpSplit;
                    BIHNode tmpNode = nearNode;
                    nearNode = farNode;
                    farNode = tmpNode;
                }
                if (tMin > tNearSplit && tMax < tFarSplit) continue block0;
                if (tMin > tNearSplit) {
                    tMin = Math.max(tMin, tFarSplit);
                    node = farNode;
                    continue;
                }
                if (tMax < tFarSplit) {
                    tMax = Math.min(tMax, tNearSplit);
                    node = nearNode;
                    continue;
                }
                stack.add(new BIHStackData(farNode, Math.max(tMin, tFarSplit), tMax));
                tMax = Math.min(tMax, tNearSplit);
                node = nearNode;
            }
            for (int i = node.leftIndex; i <= node.rightIndex; ++i) {
                tree.getTriangle(i, v1, v2, v3);
                float t = r.intersects(v1, v2, v3);
                if (Float.isInfinite(t)) continue;
                if (worldMatrix != null) {
                    float t_world;
                    worldMatrix.mult(v1, v1);
                    worldMatrix.mult(v2, v2);
                    worldMatrix.mult(v3, v3);
                    t = t_world = new Ray(o, d).intersects(v1, v2, v3);
                }
                if (Float.isInfinite(t)) continue;
                Vector3f contactNormal = Triangle.computeTriangleNormal(v1, v2, v3, null);
                Vector3f contactPoint = new Vector3f(d).multLocal(t).addLocal(o);
                float worldSpaceDist = o.distance(contactPoint);
                CollisionResult cr = new CollisionResult(contactPoint, worldSpaceDist);
                cr.setContactNormal(contactNormal);
                cr.setTriangleIndex(tree.getTriangleIndex(i));
                results.addCollision(cr);
                ++cols;
            }
        }
        vars.release();
        r.setOrigin(o);
        r.setDirection(d);
        return cols;
    }

    public static final class BIHStackData {
        private final BIHNode node;
        private final float min;
        private final float max;

        BIHStackData(BIHNode node, float min, float max) {
            this.node = node;
            this.min = min;
            this.max = max;
        }
    }
}

