/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.AnimationUtils;
import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.MotionPath;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class MotionEvent
extends AbstractCinematicEvent
implements Control,
JmeCloneable {
    protected Spatial spatial;
    protected int currentWayPoint;
    protected float currentValue;
    protected Vector3f direction = new Vector3f();
    protected Vector3f lookAt = null;
    protected Vector3f upVector = Vector3f.UNIT_Y;
    protected Quaternion rotation = null;
    protected Direction directionType = Direction.None;
    protected MotionPath path;
    private boolean isControl = true;
    protected float traveledDistance = 0.0f;

    public MotionEvent() {
    }

    public MotionEvent(Spatial spatial, MotionPath path) {
        spatial.addControl(this);
        this.path = path;
    }

    public MotionEvent(Spatial spatial, MotionPath path, float initialDuration) {
        super(initialDuration);
        spatial.addControl(this);
        this.path = path;
    }

    public MotionEvent(Spatial spatial, MotionPath path, LoopMode loopMode) {
        spatial.addControl(this);
        this.path = path;
        this.loopMode = loopMode;
    }

    public MotionEvent(Spatial spatial, MotionPath path, float initialDuration, LoopMode loopMode) {
        super(initialDuration);
        spatial.addControl(this);
        this.path = path;
        this.loopMode = loopMode;
    }

    @Override
    public void update(float tpf) {
        if (this.isControl) {
            this.internalUpdate(tpf);
        }
    }

    @Override
    public void internalUpdate(float tpf) {
        if (this.playState == PlayState.Playing) {
            this.time += tpf * this.speed;
            if (this.loopMode == LoopMode.Loop && this.time < 0.0f) {
                this.time = this.initialDuration;
            }
            if ((this.time >= this.initialDuration || this.time < 0.0f) && this.loopMode == LoopMode.DontLoop) {
                if (this.time >= this.initialDuration) {
                    this.path.triggerWayPointReach(this.path.getNbWayPoints() - 1, this);
                }
                this.stop();
            } else {
                this.time = AnimationUtils.clampWrapTime(this.time, this.initialDuration, this.loopMode);
                if (this.time < 0.0f) {
                    this.speed = -this.speed;
                    this.time = -this.time;
                }
                this.onUpdate(tpf);
            }
        }
    }

    @Override
    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        this.isControl = false;
    }

    @Override
    public void setTime(float time) {
        super.setTime(time);
        this.onUpdate(0.0f);
    }

    @Override
    public void onUpdate(float tpf) {
        this.traveledDistance = this.path.interpolatePath(this.time, this, tpf);
        this.computeTargetDirection();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.lookAt, "lookAt", null);
        oc.write(this.upVector, "upVector", Vector3f.UNIT_Y);
        oc.write(this.rotation, "rotation", null);
        oc.write(this.directionType, "directionType", Direction.None);
        oc.write(this.path, "path", null);
        oc.write(this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule in = im.getCapsule(this);
        this.lookAt = (Vector3f)in.readSavable("lookAt", null);
        this.upVector = (Vector3f)in.readSavable("upVector", Vector3f.UNIT_Y);
        this.rotation = (Quaternion)in.readSavable("rotation", null);
        this.directionType = in.readEnum("directionType", Direction.class, Direction.None);
        this.path = (MotionPath)in.readSavable("path", null);
        this.spatial = (Spatial)in.readSavable("spatial", null);
    }

    public boolean needsDirection() {
        return this.directionType == Direction.Path || this.directionType == Direction.PathAndRotation;
    }

    private void computeTargetDirection() {
        switch (this.directionType.ordinal()) {
            case 1: {
                Quaternion q = new Quaternion();
                q.lookAt(this.direction, this.upVector);
                this.spatial.setLocalRotation(q);
                break;
            }
            case 4: {
                if (this.lookAt == null) break;
                this.spatial.lookAt(this.lookAt, this.upVector);
                break;
            }
            case 2: {
                if (this.rotation == null) break;
                Quaternion q2 = new Quaternion();
                q2.lookAt(this.direction, this.upVector);
                q2.multLocal(this.rotation);
                this.spatial.setLocalRotation(q2);
                break;
            }
            case 3: {
                if (this.rotation == null) break;
                this.spatial.setLocalRotation(this.rotation);
                break;
            }
            case 0: {
                break;
            }
        }
    }

    @Override
    @Deprecated
    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object jmeClone() {
        MotionEvent control = new MotionEvent();
        control.path = this.path;
        control.playState = this.playState;
        control.currentWayPoint = this.currentWayPoint;
        control.currentValue = this.currentValue;
        control.direction = this.direction.clone();
        control.lookAt = this.lookAt;
        control.upVector = this.upVector.clone();
        control.rotation = this.rotation;
        control.initialDuration = this.initialDuration;
        control.speed = this.speed;
        control.loopMode = this.loopMode;
        control.directionType = this.directionType;
        control.spatial = this.spatial;
        return control;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.lookAt = cloner.clone(this.lookAt);
        this.path = cloner.clone(this.path);
        this.rotation = cloner.clone(this.rotation);
        this.spatial = cloner.clone(this.spatial);
    }

    @Override
    public void onPlay() {
        this.traveledDistance = 0.0f;
    }

    @Override
    public void onStop() {
        this.currentWayPoint = 0;
    }

    @Override
    public void onPause() {
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(float currentValue) {
        this.currentValue = currentValue;
    }

    public int getCurrentWayPoint() {
        return this.currentWayPoint;
    }

    public void setCurrentWayPoint(int currentWayPoint) {
        this.currentWayPoint = currentWayPoint;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.setDirection(direction, Vector3f.UNIT_Y);
    }

    public void setDirection(Vector3f direction, Vector3f upVector) {
        this.direction.set(direction);
        this.upVector.set(upVector);
    }

    public Direction getDirectionType() {
        return this.directionType;
    }

    public void setDirectionType(Direction directionType) {
        this.directionType = directionType;
    }

    public void setLookAt(Vector3f lookAt, Vector3f upVector) {
        this.lookAt = lookAt;
        this.upVector = upVector;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternion rotation) {
        this.rotation = rotation;
    }

    public MotionPath getPath() {
        return this.path;
    }

    public void setPath(MotionPath path) {
        this.path = path;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.play();
        } else {
            this.pause();
        }
    }

    public boolean isEnabled() {
        return this.playState != PlayState.Stopped;
    }

    @Override
    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public float getTraveledDistance() {
        return this.traveledDistance;
    }

    public static enum Direction {
        None,
        Path,
        PathAndRotation,
        Rotation,
        LookAt;

    }
}

