/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.util.SafeArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class ConstantVerifierState
extends BaseAppState {
    private static final Logger log = Logger.getLogger(BaseAppState.class.getName());
    private static final Checker[] DEFAULT_CHECKS = new Checker[]{new Checker(Vector3f.ZERO, new Vector3f(0.0f, 0.0f, 0.0f)), new Checker(Vector3f.NAN, new Vector3f(Float.NaN, Float.NaN, Float.NaN)), new Checker(Vector3f.UNIT_X, new Vector3f(1.0f, 0.0f, 0.0f)), new Checker(Vector3f.UNIT_Y, new Vector3f(0.0f, 1.0f, 0.0f)), new Checker(Vector3f.UNIT_Z, new Vector3f(0.0f, 0.0f, 1.0f)), new Checker(Vector3f.UNIT_XYZ, new Vector3f(1.0f, 1.0f, 1.0f)), new Checker(Vector3f.POSITIVE_INFINITY, new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY)), new Checker(Vector3f.NEGATIVE_INFINITY, new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY)), new Checker(Quaternion.IDENTITY, new Quaternion()), new Checker(Quaternion.DIRECTION_Z, new Quaternion().fromAxes(Vector3f.UNIT_X, Vector3f.UNIT_Y, Vector3f.UNIT_Z)), new Checker(Quaternion.ZERO, new Quaternion(0.0f, 0.0f, 0.0f, 0.0f)), new Checker(Vector2f.ZERO, new Vector2f(0.0f, 0.0f)), new Checker(Vector2f.UNIT_XY, new Vector2f(1.0f, 1.0f)), new Checker(Vector4f.ZERO, new Vector4f(0.0f, 0.0f, 0.0f, 0.0f)), new Checker(Vector4f.NAN, new Vector4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN)), new Checker(Vector4f.UNIT_X, new Vector4f(1.0f, 0.0f, 0.0f, 0.0f)), new Checker(Vector4f.UNIT_Y, new Vector4f(0.0f, 1.0f, 0.0f, 0.0f)), new Checker(Vector4f.UNIT_Z, new Vector4f(0.0f, 0.0f, 1.0f, 0.0f)), new Checker(Vector4f.UNIT_W, new Vector4f(0.0f, 0.0f, 0.0f, 1.0f)), new Checker(Vector4f.UNIT_XYZW, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f)), new Checker(Vector4f.POSITIVE_INFINITY, new Vector4f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY)), new Checker(Vector4f.NEGATIVE_INFINITY, new Vector4f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY)), new Checker(Matrix3f.ZERO, new Matrix3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)), new Checker(Matrix3f.IDENTITY, new Matrix3f()), new Checker(Matrix4f.ZERO, new Matrix4f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)), new Checker(Matrix4f.IDENTITY, new Matrix4f())};
    private final SafeArrayList<Checker> checkers = new SafeArrayList<Checker>(Checker.class);
    private ErrorType errorType;

    public ConstantVerifierState() {
        this(ErrorType.Assert);
    }

    public ConstantVerifierState(ErrorType errorType) {
        this(errorType, DEFAULT_CHECKS);
    }

    private ConstantVerifierState(ErrorType errorType, Checker ... checkers) {
        this.errorType = errorType;
        this.checkers.addAll(Arrays.asList(checkers));
    }

    public void addChecker(Object constant, Object goodValue) {
        this.checkers.add(new Checker(constant, goodValue));
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    protected void initialize(Application app) {
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
    }

    @Override
    protected void onDisable() {
    }

    @Override
    public void postRender() {
        this.checkValues();
    }

    protected void checkValues() {
        block4: for (Checker checker : this.checkers.getArray()) {
            switch (this.errorType.ordinal()) {
                default: {
                    assert (checker.isValid()) : checker.toString();
                    continue block4;
                }
                case 1: {
                    if (checker.isValid()) continue block4;
                    throw new RuntimeException("Constant has changed, " + checker.toString());
                }
                case 2: {
                    if (checker.isValid()) continue block4;
                    log.severe("Constant has changed, " + checker.toString());
                }
            }
        }
    }

    public static enum ErrorType {
        Assert,
        Exception,
        Log;

    }

    private static class Checker {
        private Object constant;
        private Object goodValue;

        public Checker(Object constant, Object goodValue) {
            if (constant == null) {
                throw new IllegalArgumentException("Constant cannot be null");
            }
            if (!constant.equals(goodValue)) {
                throw new IllegalArgumentException("Constant value:" + constant + " does not match value:" + goodValue);
            }
            this.constant = constant;
            this.goodValue = goodValue;
        }

        public boolean isValid() {
            return this.constant.equals(this.goodValue);
        }

        public String toString() {
            return "Constant:" + this.constant + ", correct value:" + this.goodValue + ", type:" + this.goodValue.getClass();
        }
    }
}

