/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.AnimLayer;
import com.jme3.anim.AnimationMask;
import com.jme3.anim.Armature;
import com.jme3.anim.ArmatureMask;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import java.io.IOException;

public class SingleLayerInfluenceMask
extends ArmatureMask {
    private String targetLayer;
    private AnimComposer animComposer;

    protected SingleLayerInfluenceMask() {
    }

    public SingleLayerInfluenceMask(String targetLayer, AnimComposer animComposer, Armature armature) {
        super(armature);
        this.targetLayer = targetLayer;
        this.animComposer = animComposer;
    }

    public SingleLayerInfluenceMask(String targetLayer, AnimComposer animComposer) {
        this.targetLayer = targetLayer;
        this.animComposer = animComposer;
    }

    public String getTargetLayer() {
        return this.targetLayer;
    }

    public void setAnimComposer(AnimComposer animComposer) {
        this.animComposer = animComposer;
    }

    @Override
    public boolean contains(Object target) {
        return this.simpleContains(target) && (this.animComposer == null || !this.isAffectedByUpperLayers(target));
    }

    private boolean simpleContains(Object target) {
        return super.contains(target);
    }

    private boolean isAffectedByUpperLayers(Object target) {
        boolean higher = false;
        for (String layerName : this.animComposer.getLayerNames()) {
            AnimationMask mask;
            AnimLayer animLayer;
            if (layerName.equals(this.targetLayer)) {
                higher = true;
                continue;
            }
            if (!higher || (animLayer = this.animComposer.getLayer(layerName)).getCurrentAction() == null || !((mask = animLayer.getMask()) instanceof SingleLayerInfluenceMask ? ((SingleLayerInfluenceMask)mask).simpleContains(target) : mask != null && mask.contains(target))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.targetLayer, "targetLayer", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.targetLayer = ic.readString("targetLayer", null);
    }
}

