/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimationMask;
import com.jme3.anim.tween.action.Action;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class AnimLayer
implements JmeCloneable,
Savable {
    private Action currentAction;
    private String currentActionName;
    private AnimationMask mask;
    private double time;
    private Object manager;
    private String name;
    private boolean loop = true;

    protected AnimLayer() {
    }

    AnimLayer(String name, AnimationMask mask) {
        assert (name != null);
        this.name = name;
        this.mask = mask;
    }

    public Action getCurrentAction() {
        return this.currentAction;
    }

    public String getCurrentActionName() {
        return this.currentActionName;
    }

    public Object getManager() {
        return this.manager;
    }

    public AnimationMask getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public double getTime() {
        return this.time;
    }

    public void setCurrentAction(Action actionToRun) {
        this.setCurrentAction(null, actionToRun);
    }

    public void setCurrentAction(String actionName, Action actionToRun) {
        this.setCurrentAction(actionName, actionToRun, true);
    }

    public void setCurrentAction(String actionName, Action actionToRun, boolean loop) {
        this.time = 0.0;
        this.currentAction = actionToRun;
        this.currentActionName = actionName;
        this.loop = loop;
    }

    public void setManager(Object manager) {
        this.manager = manager;
    }

    public void setTime(double animationTime) {
        double length = this.currentAction.getLength();
        this.time = animationTime >= 0.0 ? animationTime % length : animationTime % length + length;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public void setLooping(boolean loop) {
        this.loop = loop;
    }

    void update(float appDeltaTimeInSeconds, float globalSpeed) {
        Action action = this.currentAction;
        if (action == null) {
            return;
        }
        double speedup = action.getSpeed() * (double)globalSpeed;
        double scaledDeltaTime = speedup * (double)appDeltaTimeInSeconds;
        this.time += scaledDeltaTime;
        if (this.time < 0.0) {
            double length = action.getLength();
            this.time = (this.time % length + length) % length;
        }
        action.setMask(this.mask);
        boolean running = action.interpolate(this.time);
        action.setMask(null);
        if (!running) {
            this.time = 0.0;
            if (!this.loop) {
                this.setCurrentAction(null);
            }
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.currentAction = null;
        this.currentActionName = null;
    }

    @Override
    public Object jmeClone() {
        try {
            AnimLayer clone = (AnimLayer)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError();
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", null);
        if (this.mask instanceof Savable) {
            oc.write((Savable)((Object)this.mask), "mask", null);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", null);
        this.mask = (AnimationMask)((Object)ic.readSavable("mask", null));
    }
}

