/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.light.DefaultLightFilter;
import com.jme3.light.LightFilter;
import com.jme3.light.LightList;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.material.Technique;
import com.jme3.material.TechniqueDef;
import com.jme3.math.Matrix4f;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.profile.AppStep;
import com.jme3.profile.SpStep;
import com.jme3.profile.VpStep;
import com.jme3.renderer.Camera;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Shader;
import com.jme3.shader.UniformBindingManager;
import com.jme3.system.NullRenderer;
import com.jme3.system.Timer;
import com.jme3.util.SafeArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class RenderManager {
    private static final Logger logger = Logger.getLogger(RenderManager.class.getName());
    private final Renderer renderer;
    private final UniformBindingManager uniformBindingManager = new UniformBindingManager();
    private final ArrayList<ViewPort> preViewPorts = new ArrayList();
    private final ArrayList<ViewPort> viewPorts = new ArrayList();
    private final ArrayList<ViewPort> postViewPorts = new ArrayList();
    private Camera prevCam = null;
    private Material forcedMaterial = null;
    private String forcedTechnique = null;
    private RenderState forcedRenderState = null;
    private final SafeArrayList<MatParamOverride> forcedOverrides = new SafeArrayList<MatParamOverride>(MatParamOverride.class);
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;
    private final Matrix4f orthoMatrix = new Matrix4f();
    private final LightList filteredLightList = new LightList(null);
    private boolean handleTranslucentBucket = true;
    private AppProfiler prof;
    private LightFilter lightFilter = new DefaultLightFilter();
    private TechniqueDef.LightMode preferredLightMode = TechniqueDef.LightMode.MultiPass;
    private int singlePassLightBatchSize = 1;

    public RenderManager(Renderer renderer) {
        this.renderer = renderer;
    }

    public ViewPort getPreView(String viewName) {
        for (int i = 0; i < this.preViewPorts.size(); ++i) {
            if (!this.preViewPorts.get(i).getName().equals(viewName)) continue;
            return this.preViewPorts.get(i);
        }
        return null;
    }

    public boolean removePreView(String viewName) {
        for (int i = 0; i < this.preViewPorts.size(); ++i) {
            if (!this.preViewPorts.get(i).getName().equals(viewName)) continue;
            this.preViewPorts.remove(i);
            return true;
        }
        return false;
    }

    public boolean removePreView(ViewPort view) {
        return this.preViewPorts.remove(view);
    }

    public ViewPort getMainView(String viewName) {
        for (int i = 0; i < this.viewPorts.size(); ++i) {
            if (!this.viewPorts.get(i).getName().equals(viewName)) continue;
            return this.viewPorts.get(i);
        }
        return null;
    }

    public boolean removeMainView(String viewName) {
        for (int i = 0; i < this.viewPorts.size(); ++i) {
            if (!this.viewPorts.get(i).getName().equals(viewName)) continue;
            this.viewPorts.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeMainView(ViewPort view) {
        return this.viewPorts.remove(view);
    }

    public ViewPort getPostView(String viewName) {
        for (int i = 0; i < this.postViewPorts.size(); ++i) {
            if (!this.postViewPorts.get(i).getName().equals(viewName)) continue;
            return this.postViewPorts.get(i);
        }
        return null;
    }

    public boolean removePostView(String viewName) {
        for (int i = 0; i < this.postViewPorts.size(); ++i) {
            if (!this.postViewPorts.get(i).getName().equals(viewName)) continue;
            this.postViewPorts.remove(i);
            return true;
        }
        return false;
    }

    public boolean removePostView(ViewPort view) {
        return this.postViewPorts.remove(view);
    }

    public List<ViewPort> getPreViews() {
        return Collections.unmodifiableList(this.preViewPorts);
    }

    public List<ViewPort> getMainViews() {
        return Collections.unmodifiableList(this.viewPorts);
    }

    public List<ViewPort> getPostViews() {
        return Collections.unmodifiableList(this.postViewPorts);
    }

    public ViewPort createPreView(String viewName, Camera cam) {
        ViewPort vp = new ViewPort(viewName, cam);
        this.preViewPorts.add(vp);
        return vp;
    }

    public ViewPort createMainView(String viewName, Camera cam) {
        ViewPort vp = new ViewPort(viewName, cam);
        this.viewPorts.add(vp);
        return vp;
    }

    public ViewPort createPostView(String viewName, Camera cam) {
        ViewPort vp = new ViewPort(viewName, cam);
        this.postViewPorts.add(vp);
        return vp;
    }

    private void notifyReshape(ViewPort vp, int w, int h) {
        SafeArrayList<SceneProcessor> processors = vp.getProcessors();
        for (SceneProcessor proc : processors) {
            if (!proc.isInitialized()) {
                proc.initialize(this, vp);
                continue;
            }
            proc.reshape(vp, w, h);
        }
    }

    private void notifyRescale(ViewPort vp, float x, float y) {
        SafeArrayList<SceneProcessor> processors = vp.getProcessors();
        for (SceneProcessor proc : processors) {
            if (!proc.isInitialized()) {
                proc.initialize(this, vp);
                continue;
            }
            proc.rescale(vp, x, y);
        }
    }

    public void notifyReshape(int w, int h) {
        Camera cam;
        for (ViewPort vp : this.preViewPorts) {
            if (vp.getOutputFrameBuffer() == null) {
                cam = vp.getCamera();
                cam.resize(w, h, true);
            }
            this.notifyReshape(vp, w, h);
        }
        for (ViewPort vp : this.viewPorts) {
            if (vp.getOutputFrameBuffer() == null) {
                cam = vp.getCamera();
                cam.resize(w, h, true);
            }
            this.notifyReshape(vp, w, h);
        }
        for (ViewPort vp : this.postViewPorts) {
            if (vp.getOutputFrameBuffer() == null) {
                cam = vp.getCamera();
                cam.resize(w, h, true);
            }
            this.notifyReshape(vp, w, h);
        }
    }

    public void notifyRescale(float x, float y) {
        for (ViewPort vp : this.preViewPorts) {
            this.notifyRescale(vp, x, y);
        }
        for (ViewPort vp : this.viewPorts) {
            this.notifyRescale(vp, x, y);
        }
        for (ViewPort vp : this.postViewPorts) {
            this.notifyRescale(vp, x, y);
        }
    }

    public void setForcedMaterial(Material mat) {
        this.forcedMaterial = mat;
    }

    public RenderState getForcedRenderState() {
        return this.forcedRenderState;
    }

    public void setForcedRenderState(RenderState forcedRenderState) {
        this.forcedRenderState = forcedRenderState;
    }

    public void setTimer(Timer timer) {
        this.uniformBindingManager.setTimer(timer);
    }

    public void setAppProfiler(AppProfiler prof) {
        this.prof = prof;
    }

    public String getForcedTechnique() {
        return this.forcedTechnique;
    }

    public void setForcedTechnique(String forcedTechnique) {
        this.forcedTechnique = forcedTechnique;
    }

    public void addForcedMatParam(MatParamOverride override) {
        this.forcedOverrides.add(override);
    }

    public void removeForcedMatParam(MatParamOverride override) {
        this.forcedOverrides.remove(override);
    }

    public SafeArrayList<MatParamOverride> getForcedMatParams() {
        return this.forcedOverrides;
    }

    public void setAlphaToCoverage(boolean value) {
        this.renderer.setAlphaToCoverage(value);
    }

    public boolean isHandleTranslucentBucket() {
        return this.handleTranslucentBucket;
    }

    public void setHandleTranslucentBucket(boolean handleTranslucentBucket) {
        this.handleTranslucentBucket = handleTranslucentBucket;
    }

    public void setWorldMatrix(Matrix4f mat) {
        this.uniformBindingManager.setWorldMatrix(mat);
    }

    public void updateUniformBindings(Shader shader) {
        this.uniformBindingManager.updateUniformBindings(shader);
    }

    public void renderGeometry(Geometry geom) {
        this.renderer.pushDebugGroup(geom.getName());
        if (geom.isIgnoreTransform()) {
            this.setWorldMatrix(Matrix4f.IDENTITY);
        } else {
            this.setWorldMatrix(geom.getWorldMatrix());
        }
        LightList lightList = geom.getWorldLightList();
        if (this.lightFilter != null) {
            this.filteredLightList.clear();
            this.lightFilter.filterLights(geom, this.filteredLightList);
            lightList = this.filteredLightList;
        }
        Material material = geom.getMaterial();
        if (this.forcedTechnique != null) {
            MaterialDef matDef = material.getMaterialDef();
            if (matDef.getTechniqueDefs(this.forcedTechnique) != null) {
                Technique activeTechnique = material.getActiveTechnique();
                String previousTechniqueName = activeTechnique != null ? activeTechnique.getDef().getName() : "Default";
                geom.getMaterial().selectTechnique(this.forcedTechnique, this);
                RenderState tmpRs = this.forcedRenderState;
                if (geom.getMaterial().getActiveTechnique().getDef().getForcedRenderState() != null) {
                    this.forcedRenderState = geom.getMaterial().getActiveTechnique().getDef().getForcedRenderState();
                }
                material.render(geom, lightList, this);
                material.selectTechnique(previousTechniqueName, this);
                this.forcedRenderState = tmpRs;
            } else if (this.forcedMaterial != null) {
                this.forcedMaterial.render(geom, lightList, this);
            }
        } else if (this.forcedMaterial != null) {
            this.forcedMaterial.render(geom, lightList, this);
        } else {
            material.render(geom, lightList, this);
        }
        this.renderer.popDebugGroup();
    }

    public void renderGeometryList(GeometryList gl) {
        for (int i = 0; i < gl.size(); ++i) {
            this.renderGeometry(gl.get(i));
        }
    }

    public void preloadScene(Spatial scene) {
        block5: {
            block4: {
                if (!(scene instanceof Node)) break block4;
                Node n = (Node)scene;
                List<Spatial> children = n.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    this.preloadScene(children.get(i));
                }
                break block5;
            }
            if (!(scene instanceof Geometry)) break block5;
            Geometry gm = (Geometry)scene;
            if (gm.getMaterial() == null) {
                throw new IllegalStateException("No material is set for Geometry: " + gm.getName());
            }
            gm.getMaterial().preload(this, gm);
            Mesh mesh = gm.getMesh();
            if (mesh != null && mesh.getVertexCount() != 0 && mesh.getTriangleCount() != 0) {
                for (VertexBuffer vb : mesh.getBufferList().getArray()) {
                    if (vb.getData() == null || vb.getUsage() == VertexBuffer.Usage.CpuOnly) continue;
                    this.renderer.updateBufferData(vb);
                }
            }
        }
    }

    public void renderScene(Spatial scene, ViewPort vp) {
        vp.getCamera().setPlaneState(0);
        this.renderSubScene(scene, vp);
    }

    private void renderSubScene(Spatial scene, ViewPort vp) {
        if (!scene.checkCulling(vp.getCamera())) {
            return;
        }
        scene.runControlRender(this, vp);
        if (scene instanceof Node) {
            Node n = (Node)scene;
            List<Spatial> children = n.getChildren();
            int camState = vp.getCamera().getPlaneState();
            for (int i = 0; i < children.size(); ++i) {
                vp.getCamera().setPlaneState(camState);
                this.renderSubScene(children.get(i), vp);
            }
        } else if (scene instanceof Geometry) {
            Geometry gm = (Geometry)scene;
            if (gm.getMaterial() == null) {
                throw new IllegalStateException("No material is set for Geometry: " + gm.getName());
            }
            vp.getQueue().addToQueue(gm, scene.getQueueBucket());
        }
    }

    public Camera getCurrentCamera() {
        return this.prevCam;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void flushQueue(ViewPort vp) {
        this.renderViewPortQueues(vp, true);
    }

    public void clearQueue(ViewPort vp) {
        vp.getQueue().clear();
    }

    public void setLightFilter(LightFilter lightFilter) {
        this.lightFilter = lightFilter;
    }

    public LightFilter getLightFilter() {
        return this.lightFilter;
    }

    public void setPreferredLightMode(TechniqueDef.LightMode preferredLightMode) {
        this.preferredLightMode = preferredLightMode;
    }

    public TechniqueDef.LightMode getPreferredLightMode() {
        return this.preferredLightMode;
    }

    public int getSinglePassLightBatchSize() {
        return this.singlePassLightBatchSize;
    }

    public void setSinglePassLightBatchSize(int singlePassLightBatchSize) {
        this.singlePassLightBatchSize = singlePassLightBatchSize < 1 ? 1 : singlePassLightBatchSize;
    }

    public void renderViewPortQueues(ViewPort vp, boolean flush) {
        RenderQueue rq = vp.getQueue();
        Camera cam = vp.getCamera();
        boolean depthRangeChanged = false;
        if (this.prof != null) {
            this.prof.vpStep(VpStep.RenderBucket, vp, RenderQueue.Bucket.Opaque);
        }
        this.renderer.pushDebugGroup(RenderQueue.Bucket.Opaque.name());
        rq.renderQueue(RenderQueue.Bucket.Opaque, this, cam, flush);
        this.renderer.popDebugGroup();
        if (!rq.isQueueEmpty(RenderQueue.Bucket.Sky)) {
            if (this.prof != null) {
                this.prof.vpStep(VpStep.RenderBucket, vp, RenderQueue.Bucket.Sky);
            }
            this.renderer.setDepthRange(1.0f, 1.0f);
            this.renderer.pushDebugGroup(RenderQueue.Bucket.Sky.name());
            rq.renderQueue(RenderQueue.Bucket.Sky, this, cam, flush);
            this.renderer.popDebugGroup();
            depthRangeChanged = true;
        }
        if (!rq.isQueueEmpty(RenderQueue.Bucket.Transparent)) {
            if (this.prof != null) {
                this.prof.vpStep(VpStep.RenderBucket, vp, RenderQueue.Bucket.Transparent);
            }
            if (depthRangeChanged) {
                this.renderer.setDepthRange(0.0f, 1.0f);
                depthRangeChanged = false;
            }
            this.renderer.pushDebugGroup(RenderQueue.Bucket.Transparent.name());
            rq.renderQueue(RenderQueue.Bucket.Transparent, this, cam, flush);
            this.renderer.popDebugGroup();
        }
        if (!rq.isQueueEmpty(RenderQueue.Bucket.Gui)) {
            if (this.prof != null) {
                this.prof.vpStep(VpStep.RenderBucket, vp, RenderQueue.Bucket.Gui);
            }
            this.renderer.setDepthRange(0.0f, 0.0f);
            this.setCamera(cam, true);
            this.renderer.pushDebugGroup(RenderQueue.Bucket.Gui.name());
            rq.renderQueue(RenderQueue.Bucket.Gui, this, cam, flush);
            this.renderer.popDebugGroup();
            this.setCamera(cam, false);
            depthRangeChanged = true;
        }
        if (depthRangeChanged) {
            this.renderer.setDepthRange(0.0f, 1.0f);
        }
    }

    public void renderTranslucentQueue(ViewPort vp) {
        RenderQueue rq;
        if (this.prof != null) {
            this.prof.vpStep(VpStep.RenderBucket, vp, RenderQueue.Bucket.Translucent);
        }
        if (!(rq = vp.getQueue()).isQueueEmpty(RenderQueue.Bucket.Translucent) && this.handleTranslucentBucket) {
            rq.renderQueue(RenderQueue.Bucket.Translucent, this, vp.getCamera(), true);
        }
    }

    private void setViewPort(Camera cam) {
        if (cam != this.prevCam || cam.isViewportChanged()) {
            this.viewX = (int)(cam.getViewPortLeft() * (float)cam.getWidth());
            this.viewY = (int)(cam.getViewPortBottom() * (float)cam.getHeight());
            int viewX2 = (int)(cam.getViewPortRight() * (float)cam.getWidth());
            int viewY2 = (int)(cam.getViewPortTop() * (float)cam.getHeight());
            this.viewWidth = viewX2 - this.viewX;
            this.viewHeight = viewY2 - this.viewY;
            this.uniformBindingManager.setViewPort(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
            this.renderer.setViewPort(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
            this.renderer.setClipRect(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
            cam.clearViewportChanged();
            this.prevCam = cam;
            this.orthoMatrix.loadIdentity();
            this.orthoMatrix.setTranslation(-1.0f, -1.0f, 0.0f);
            this.orthoMatrix.setScale(2.0f / (float)cam.getWidth(), 2.0f / (float)cam.getHeight(), 0.0f);
        }
    }

    private void setViewProjection(Camera cam, boolean ortho) {
        if (ortho) {
            this.uniformBindingManager.setCamera(cam, Matrix4f.IDENTITY, this.orthoMatrix, this.orthoMatrix);
        } else {
            this.uniformBindingManager.setCamera(cam, cam.getViewMatrix(), cam.getProjectionMatrix(), cam.getViewProjectionMatrix());
        }
    }

    public void setCamera(Camera cam, boolean ortho) {
        if (this.lightFilter != null) {
            this.lightFilter.setCamera(cam);
        }
        this.setViewPort(cam);
        this.setViewProjection(cam, ortho);
    }

    public void renderViewPortRaw(ViewPort vp) {
        this.setCamera(vp.getCamera(), false);
        SafeArrayList<Spatial> scenes = vp.getScenes();
        for (int i = scenes.size() - 1; i >= 0; --i) {
            this.renderScene((Spatial)scenes.get(i), vp);
        }
        this.flushQueue(vp);
    }

    public void renderViewPort(ViewPort vp, float tpf) {
        SafeArrayList<SceneProcessor> processors;
        if (!vp.isEnabled()) {
            return;
        }
        if (this.prof != null) {
            this.prof.vpStep(VpStep.BeginRender, vp, null);
        }
        if ((processors = vp.getProcessors()).isEmpty()) {
            processors = null;
        }
        if (processors != null) {
            if (this.prof != null) {
                this.prof.vpStep(VpStep.PreFrame, vp, null);
            }
            for (SceneProcessor proc : processors.getArray()) {
                if (!proc.isInitialized()) {
                    proc.initialize(this, vp);
                }
                proc.setProfiler(this.prof);
                if (this.prof != null) {
                    this.prof.spStep(SpStep.ProcPreFrame, proc.getClass().getSimpleName());
                }
                proc.preFrame(tpf);
            }
        }
        this.renderer.setFrameBuffer(vp.getOutputFrameBuffer());
        this.setCamera(vp.getCamera(), false);
        if (vp.isClearDepth() || vp.isClearColor() || vp.isClearStencil()) {
            if (vp.isClearColor()) {
                this.renderer.setBackgroundColor(vp.getBackgroundColor());
            }
            this.renderer.clearBuffers(vp.isClearColor(), vp.isClearDepth(), vp.isClearStencil());
        }
        if (this.prof != null) {
            this.prof.vpStep(VpStep.RenderScene, vp, null);
        }
        SafeArrayList<Spatial> scenes = vp.getScenes();
        for (int i = scenes.size() - 1; i >= 0; --i) {
            this.renderScene((Spatial)scenes.get(i), vp);
        }
        if (processors != null) {
            if (this.prof != null) {
                this.prof.vpStep(VpStep.PostQueue, vp, null);
            }
            for (SceneProcessor proc : processors.getArray()) {
                if (this.prof != null) {
                    this.prof.spStep(SpStep.ProcPostQueue, proc.getClass().getSimpleName());
                }
                proc.postQueue(vp.getQueue());
            }
        }
        if (this.prof != null) {
            this.prof.vpStep(VpStep.FlushQueue, vp, null);
        }
        this.flushQueue(vp);
        if (processors != null) {
            if (this.prof != null) {
                this.prof.vpStep(VpStep.PostFrame, vp, null);
            }
            for (SceneProcessor proc : processors.getArray()) {
                if (this.prof != null) {
                    this.prof.spStep(SpStep.ProcPostFrame, proc.getClass().getSimpleName());
                }
                proc.postFrame(vp.getOutputFrameBuffer());
            }
            if (this.prof != null) {
                this.prof.vpStep(VpStep.ProcEndRender, vp, null);
            }
        }
        this.renderTranslucentQueue(vp);
        this.clearQueue(vp);
        if (this.prof != null) {
            this.prof.vpStep(VpStep.EndRender, vp, null);
        }
    }

    public void render(float tpf, boolean mainFrameBufferActive) {
        ViewPort vp;
        int i;
        if (this.renderer instanceof NullRenderer) {
            return;
        }
        this.uniformBindingManager.newFrame();
        if (this.prof != null) {
            this.prof.appStep(AppStep.RenderPreviewViewPorts);
        }
        for (i = 0; i < this.preViewPorts.size(); ++i) {
            vp = this.preViewPorts.get(i);
            if (vp.getOutputFrameBuffer() == null && !mainFrameBufferActive) continue;
            this.renderViewPort(vp, tpf);
        }
        if (this.prof != null) {
            this.prof.appStep(AppStep.RenderMainViewPorts);
        }
        for (i = 0; i < this.viewPorts.size(); ++i) {
            vp = this.viewPorts.get(i);
            if (vp.getOutputFrameBuffer() == null && !mainFrameBufferActive) continue;
            this.renderViewPort(vp, tpf);
        }
        if (this.prof != null) {
            this.prof.appStep(AppStep.RenderPostViewPorts);
        }
        for (i = 0; i < this.postViewPorts.size(); ++i) {
            vp = this.postViewPorts.get(i);
            if (vp.getOutputFrameBuffer() == null && !mainFrameBufferActive) continue;
            this.renderViewPort(vp, tpf);
        }
    }
}

