/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bounding;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.bounding.Intersection;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.UnsupportedCollisionException;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Plane;
import com.jme3.math.Ray;
import com.jme3.math.Transform;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BoundingSphere
extends BoundingVolume {
    private static final Logger logger = Logger.getLogger(BoundingSphere.class.getName());
    float radius;
    private static final float RADIUS_EPSILON = 1.00001f;

    public BoundingSphere() {
    }

    public BoundingSphere(float r, Vector3f c) {
        this.center.set(c);
        this.radius = r;
    }

    @Override
    public BoundingVolume.Type getType() {
        return BoundingVolume.Type.Sphere;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    @Override
    public void computeFromPoints(FloatBuffer points) {
        this.calcWelzl(points);
    }

    public void computeFromTris(Triangle[] tris, int start, int end) {
        if (end - start <= 0) {
            return;
        }
        Vector3f[] vertList = new Vector3f[(end - start) * 3];
        int count = 0;
        for (int i = start; i < end; ++i) {
            vertList[count++] = tris[i].get(0);
            vertList[count++] = tris[i].get(1);
            vertList[count++] = tris[i].get(2);
        }
        this.averagePoints(vertList);
    }

    public void calcWelzl(FloatBuffer points) {
        if (this.center == null) {
            this.center = new Vector3f();
        }
        FloatBuffer buf = BufferUtils.createFloatBuffer(points.limit());
        points.rewind();
        buf.put(points);
        buf.flip();
        this.recurseMini(buf, buf.limit() / 3, 0, 0);
    }

    private void recurseMini(FloatBuffer points, int p, int b, int ap) {
        Vector3f tempA = new Vector3f();
        Vector3f tempB = new Vector3f();
        Vector3f tempC = new Vector3f();
        Vector3f tempD = new Vector3f();
        switch (b) {
            case 0: {
                this.radius = 0.0f;
                this.center.set(0.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                this.radius = -1.001358E-5f;
                BufferUtils.populateFromBuffer(this.center, points, ap - 1);
                break;
            }
            case 2: {
                BufferUtils.populateFromBuffer(tempA, points, ap - 1);
                BufferUtils.populateFromBuffer(tempB, points, ap - 2);
                this.setSphere(tempA, tempB);
                break;
            }
            case 3: {
                BufferUtils.populateFromBuffer(tempA, points, ap - 1);
                BufferUtils.populateFromBuffer(tempB, points, ap - 2);
                BufferUtils.populateFromBuffer(tempC, points, ap - 3);
                this.setSphere(tempA, tempB, tempC);
                break;
            }
            case 4: {
                BufferUtils.populateFromBuffer(tempA, points, ap - 1);
                BufferUtils.populateFromBuffer(tempB, points, ap - 2);
                BufferUtils.populateFromBuffer(tempC, points, ap - 3);
                BufferUtils.populateFromBuffer(tempD, points, ap - 4);
                this.setSphere(tempA, tempB, tempC, tempD);
                return;
            }
        }
        for (int i = 0; i < p; ++i) {
            BufferUtils.populateFromBuffer(tempA, points, i + ap);
            if (!(tempA.distanceSquared(this.center) - this.radius * this.radius > 1.001358E-5f)) continue;
            for (int j = i; j > 0; --j) {
                BufferUtils.populateFromBuffer(tempB, points, j + ap);
                BufferUtils.populateFromBuffer(tempC, points, j - 1 + ap);
                BufferUtils.setInBuffer(tempC, points, j + ap);
                BufferUtils.setInBuffer(tempB, points, j - 1 + ap);
            }
            this.recurseMini(points, i, b + 1, ap + 1);
        }
    }

    private void setSphere(Vector3f O, Vector3f A, Vector3f B, Vector3f C) {
        Vector3f a = A.subtract(O);
        Vector3f b = B.subtract(O);
        Vector3f c = C.subtract(O);
        float Denominator = 2.0f * (a.x * (b.y * c.z - c.y * b.z) - b.x * (a.y * c.z - c.y * a.z) + c.x * (a.y * b.z - b.y * a.z));
        if (Denominator == 0.0f) {
            this.center.set(0.0f, 0.0f, 0.0f);
            this.radius = 0.0f;
        } else {
            Vector3f o = a.cross(b).multLocal(c.lengthSquared()).addLocal(c.cross(a).multLocal(b.lengthSquared())).addLocal(b.cross(c).multLocal(a.lengthSquared())).divideLocal(Denominator);
            this.radius = o.length() * 1.00001f;
            O.add(o, this.center);
        }
    }

    private void setSphere(Vector3f O, Vector3f A, Vector3f B) {
        Vector3f b;
        Vector3f a = A.subtract(O);
        Vector3f acrossB = a.cross(b = B.subtract(O));
        float Denominator = 2.0f * acrossB.dot(acrossB);
        if (Denominator == 0.0f) {
            this.center.set(0.0f, 0.0f, 0.0f);
            this.radius = 0.0f;
        } else {
            Vector3f o = acrossB.cross(a).multLocal(b.lengthSquared()).addLocal(b.cross(acrossB).multLocal(a.lengthSquared())).divideLocal(Denominator);
            this.radius = o.length() * 1.00001f;
            O.add(o, this.center);
        }
    }

    private void setSphere(Vector3f O, Vector3f A) {
        this.radius = FastMath.sqrt(((A.x - O.x) * (A.x - O.x) + (A.y - O.y) * (A.y - O.y) + (A.z - O.z) * (A.z - O.z)) / 4.0f) + 1.00001f - 1.0f;
        this.center.interpolateLocal(O, A, 0.5f);
    }

    public void averagePoints(Vector3f[] points) {
        logger.fine("Bounding Sphere calculated using average points.");
        this.center = points[0];
        for (int i = 1; i < points.length; ++i) {
            this.center.addLocal(points[i]);
        }
        float quantity = 1.0f / (float)points.length;
        this.center.multLocal(quantity);
        float maxRadiusSqr = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            Vector3f diff = points[i].subtract(this.center);
            float radiusSqr = diff.lengthSquared();
            if (!(radiusSqr > maxRadiusSqr)) continue;
            maxRadiusSqr = radiusSqr;
        }
        this.radius = (float)Math.sqrt(maxRadiusSqr) + 1.00001f - 1.0f;
    }

    @Override
    public BoundingVolume transform(Transform trans, BoundingVolume store) {
        BoundingSphere sphere = store == null || store.getType() != BoundingVolume.Type.Sphere ? new BoundingSphere(1.0f, new Vector3f(0.0f, 0.0f, 0.0f)) : (BoundingSphere)store;
        this.center.mult(trans.getScale(), sphere.center);
        trans.getRotation().mult(sphere.center, sphere.center);
        sphere.center.addLocal(trans.getTranslation());
        sphere.radius = FastMath.abs(this.getMaxAxis(trans.getScale()) * this.radius) + 1.00001f - 1.0f;
        return sphere;
    }

    @Override
    public BoundingVolume transform(Matrix4f trans, BoundingVolume store) {
        BoundingSphere sphere = store == null || store.getType() != BoundingVolume.Type.Sphere ? new BoundingSphere(1.0f, new Vector3f(0.0f, 0.0f, 0.0f)) : (BoundingSphere)store;
        trans.mult(this.center, sphere.center);
        Vector3f axes = new Vector3f(1.0f, 1.0f, 1.0f);
        trans.mult(axes, axes);
        float ax = this.getMaxAxis(axes);
        sphere.radius = FastMath.abs(ax * this.radius) + 1.00001f - 1.0f;
        return sphere;
    }

    private float getMaxAxis(Vector3f scale) {
        float x = FastMath.abs(scale.x);
        float y = FastMath.abs(scale.y);
        float z = FastMath.abs(scale.z);
        if (x >= y) {
            if (x >= z) {
                return x;
            }
            return z;
        }
        if (y >= z) {
            return y;
        }
        return z;
    }

    @Override
    public Plane.Side whichSide(Plane plane) {
        float distance = plane.pseudoDistance(this.center);
        if (distance <= -this.radius) {
            return Plane.Side.Negative;
        }
        if (distance >= this.radius) {
            return Plane.Side.Positive;
        }
        return Plane.Side.None;
    }

    @Override
    public BoundingVolume merge(BoundingVolume volume) {
        if (volume == null) {
            return this;
        }
        switch (volume.getType()) {
            case Sphere: {
                BoundingSphere sphere = (BoundingSphere)volume;
                float temp_radius = sphere.getRadius();
                Vector3f temp_center = sphere.center;
                BoundingSphere rVal = new BoundingSphere();
                return this.merge(temp_radius, temp_center, rVal);
            }
            case AABB: {
                BoundingBox box = (BoundingBox)volume;
                Vector3f radVect = new Vector3f(box.xExtent, box.yExtent, box.zExtent);
                Vector3f temp_center = box.center;
                BoundingSphere rVal = new BoundingSphere();
                return this.merge(radVect.length(), temp_center, rVal);
            }
        }
        return null;
    }

    @Override
    public BoundingVolume mergeLocal(BoundingVolume volume) {
        if (volume == null) {
            return this;
        }
        switch (volume.getType()) {
            case Sphere: {
                BoundingSphere sphere = (BoundingSphere)volume;
                float temp_radius = sphere.getRadius();
                Vector3f temp_center = sphere.center;
                return this.merge(temp_radius, temp_center, this);
            }
            case AABB: {
                BoundingBox box = (BoundingBox)volume;
                TempVars vars = TempVars.get();
                Vector3f radVect = vars.vect1;
                radVect.set(box.xExtent, box.yExtent, box.zExtent);
                Vector3f temp_center = box.center;
                float len = radVect.length();
                vars.release();
                return this.merge(len, temp_center, this);
            }
        }
        return null;
    }

    private BoundingVolume merge(float temp_radius, Vector3f temp_center, BoundingSphere rVal) {
        TempVars vars = TempVars.get();
        float radiusDiff = temp_radius - this.radius;
        float fRDiffSqr = radiusDiff * radiusDiff;
        Vector3f diff = temp_center.subtract(this.center, vars.vect1);
        float lengthSquared = diff.lengthSquared();
        if (fRDiffSqr >= lengthSquared) {
            if (radiusDiff <= 0.0f) {
                vars.release();
                return this;
            }
            Vector3f rCenter = rVal.center;
            if (rCenter == null) {
                rCenter = new Vector3f();
                rVal.setCenter(rCenter);
            }
            rCenter.set(temp_center);
            rVal.setRadius(temp_radius);
            vars.release();
            return rVal;
        }
        float length = (float)Math.sqrt(lengthSquared);
        Vector3f rCenter = rVal.center;
        if (rCenter == null) {
            rCenter = new Vector3f();
            rVal.setCenter(rCenter);
        }
        if (length > 1.00001f && Float.isFinite(length)) {
            float coeff = (length + radiusDiff) / (2.0f * length);
            rCenter.set(this.center.addLocal(diff.multLocal(coeff)));
        } else {
            rCenter.set(this.center);
        }
        rVal.setRadius(0.5f * (length + this.radius + temp_radius));
        vars.release();
        return rVal;
    }

    @Override
    public BoundingVolume clone(BoundingVolume store) {
        if (store != null && store.getType() == BoundingVolume.Type.Sphere) {
            BoundingSphere rVal = (BoundingSphere)store;
            if (null == rVal.center) {
                rVal.center = new Vector3f();
            }
            rVal.center.set(this.center);
            rVal.radius = this.radius;
            rVal.checkPlane = this.checkPlane;
            return rVal;
        }
        return new BoundingSphere(this.radius, this.center.clone());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [Radius: " + this.radius + " Center: " + this.center + "]";
    }

    @Override
    public boolean intersects(BoundingVolume bv) {
        return bv.intersectsSphere(this);
    }

    @Override
    public boolean intersectsSphere(BoundingSphere bs) {
        return Intersection.intersect(bs, this.center, this.radius);
    }

    @Override
    public boolean intersectsBoundingBox(BoundingBox bb) {
        return Intersection.intersect(bb, this.center, this.radius);
    }

    @Override
    public boolean intersects(Ray ray) {
        assert (Vector3f.isValidVector(this.center));
        TempVars vars = TempVars.get();
        Vector3f diff = vars.vect1.set(ray.getOrigin()).subtractLocal(this.center);
        float radiusSquared = this.getRadius() * this.getRadius();
        float a = diff.dot(diff) - radiusSquared;
        if ((double)a <= 0.0) {
            vars.release();
            return true;
        }
        float b = ray.getDirection().dot(diff);
        vars.release();
        if ((double)b >= 0.0) {
            return false;
        }
        return b * b >= a;
    }

    private int collideWithRay(Ray ray, CollisionResults results) {
        TempVars vars = TempVars.get();
        Vector3f diff = vars.vect1.set(ray.getOrigin()).subtractLocal(this.center);
        float a = diff.dot(diff) - this.getRadius() * this.getRadius();
        if ((double)a <= 0.0) {
            float a1 = ray.direction.dot(diff);
            float discr = a1 * a1 - a;
            float root = FastMath.sqrt(discr);
            float distance = root - a1;
            Vector3f point = new Vector3f(ray.direction).multLocal(distance).addLocal(ray.origin);
            CollisionResult result = new CollisionResult(point, distance);
            results.addCollision(result);
            vars.release();
            return 1;
        }
        float a1 = ray.direction.dot(diff);
        vars.release();
        if ((double)a1 >= 0.0) {
            return 0;
        }
        float discr = a1 * a1 - a;
        if ((double)discr < 0.0) {
            return 0;
        }
        if (discr >= 1.0E-4f) {
            float root = FastMath.sqrt(discr);
            float dist = -a1 - root;
            Vector3f point = new Vector3f(ray.direction).multLocal(dist).addLocal(ray.origin);
            results.addCollision(new CollisionResult(point, dist));
            dist = -a1 + root;
            point = new Vector3f(ray.direction).multLocal(dist).addLocal(ray.origin);
            results.addCollision(new CollisionResult(point, dist));
            return 2;
        }
        float dist = -a1;
        Vector3f point = new Vector3f(ray.direction).multLocal(dist).addLocal(ray.origin);
        results.addCollision(new CollisionResult(point, dist));
        return 1;
    }

    private int collideWithRay(Ray ray) {
        TempVars vars = TempVars.get();
        Vector3f diff = vars.vect1.set(ray.getOrigin()).subtractLocal(this.center);
        float a = diff.dot(diff) - this.getRadius() * this.getRadius();
        if ((double)a <= 0.0) {
            vars.release();
            return 1;
        }
        float a1 = ray.direction.dot(diff);
        vars.release();
        if ((double)a1 >= 0.0) {
            return 0;
        }
        float discr = a1 * a1 - a;
        if ((double)discr < 0.0) {
            return 0;
        }
        if (discr >= 1.0E-4f) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int collideWithTri(Triangle tri, CollisionResults results) {
        TempVars tvars = TempVars.get();
        try {
            Vector3f Q;
            float distSq;
            Vector3f Q2;
            float distSq2;
            Vector3f a = tri.get1().subtract(this.center, tvars.vect1);
            Vector3f b = tri.get2().subtract(this.center, tvars.vect2);
            Vector3f c = tri.get3().subtract(this.center, tvars.vect3);
            Vector3f ab = b.subtract(a, tvars.vect4);
            Vector3f ac = c.subtract(a, tvars.vect5);
            Vector3f n = ab.cross(ac, tvars.vect6);
            float d = a.dot(n);
            float e = n.dot(n);
            if (d * d > this.radius * this.radius * e) {
                int n2 = 0;
                return n2;
            }
            Vector3f v0 = ac;
            Vector3f v1 = ab;
            Vector3f v2 = a;
            float dot00 = v0.dot(v0);
            float dot01 = v0.dot(v1);
            float dot02 = -v0.dot(v2);
            float dot11 = v1.dot(v1);
            float dot12 = -v1.dot(v2);
            float invDenom = 1.0f / (dot00 * dot11 - dot01 * dot01);
            float u = (dot11 * dot02 - dot01 * dot12) * invDenom;
            float v = (dot00 * dot12 - dot01 * dot02) * invDenom;
            if (u >= 0.0f && v >= 0.0f && u + v <= 1.0f) {
                Vector3f part1 = ac;
                Vector3f part2 = ab;
                Vector3f p = this.center.add(a.add(part1.mult(u)).addLocal(part2.mult(v)));
                CollisionResult r = new CollisionResult();
                Vector3f normal = n.normalize();
                float dist = -normal.dot(a);
                r.setDistance(dist -= this.radius);
                r.setContactNormal(normal);
                r.setContactPoint(p);
                results.addCollision(r);
                int n3 = 1;
                return n3;
            }
            Vector3f nearestPt = null;
            float nearestDist = this.radius * this.radius;
            Vector3f edge = ab;
            Vector3f base = a;
            float t = -edge.dot(base) / edge.dot(edge);
            if (t >= 0.0f && t <= 1.0f && (distSq2 = (Q2 = base.add(edge.mult(t, tvars.vect7), tvars.vect8)).dot(Q2)) < nearestDist) {
                nearestPt = Q2;
                nearestDist = distSq2;
            }
            if ((t = -(edge = ac).dot(base = a) / edge.dot(edge)) >= 0.0f && t <= 1.0f && (distSq2 = (Q2 = base.add(edge.mult(t, tvars.vect7), tvars.vect9)).dot(Q2)) < nearestDist) {
                nearestPt = Q2;
                nearestDist = distSq2;
            }
            base = b;
            Vector3f bc = c.subtract(b);
            edge = bc;
            t = -edge.dot(base) / edge.dot(edge);
            if (t >= 0.0f && t <= 1.0f && (distSq = (Q = base.add(edge.mult(t, tvars.vect7), tvars.vect10)).dot(Q)) < nearestDist) {
                nearestPt = Q;
                nearestDist = distSq;
            }
            if (nearestPt != null) {
                float dist = FastMath.sqrt(nearestDist);
                Vector3f cn = nearestPt.divide(-dist);
                CollisionResult r = new CollisionResult();
                r.setDistance(dist - this.radius);
                r.setContactNormal(cn);
                r.setContactPoint(nearestPt.add(this.center));
                results.addCollision(r);
                int n4 = 1;
                return n4;
            }
            base = a;
            t = base.dot(base);
            if (t < nearestDist) {
                nearestDist = t;
                nearestPt = base;
            }
            if ((t = (base = b).dot(base)) < nearestDist) {
                nearestDist = t;
                nearestPt = base;
            }
            if ((t = (base = c).dot(base)) < nearestDist) {
                nearestDist = t;
                nearestPt = base;
            }
            if (nearestPt != null) {
                float dist = FastMath.sqrt(nearestDist);
                Vector3f cn = nearestPt.divide(-dist);
                CollisionResult r = new CollisionResult();
                r.setDistance(dist - this.radius);
                r.setContactNormal(cn);
                r.setContactPoint(nearestPt.add(this.center));
                results.addCollision(r);
                int n5 = 1;
                return n5;
            }
            int n6 = 0;
            return n6;
        }
        finally {
            tvars.release();
        }
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) {
        if (other instanceof Ray) {
            Ray ray = (Ray)other;
            return this.collideWithRay(ray, results);
        }
        if (other instanceof Triangle) {
            Triangle t = (Triangle)other;
            return this.collideWithTri(t, results);
        }
        if (other instanceof BoundingVolume) {
            if (this.intersects((BoundingVolume)other)) {
                CollisionResult result = new CollisionResult();
                results.addCollision(result);
                return 1;
            }
            return 0;
        }
        if (other instanceof Spatial) {
            return other.collideWith(this, results);
        }
        throw new UnsupportedCollisionException();
    }

    @Override
    public int collideWith(Collidable other) {
        if (other instanceof Ray) {
            Ray ray = (Ray)other;
            return this.collideWithRay(ray);
        }
        if (other instanceof Triangle) {
            return super.collideWith(other);
        }
        if (other instanceof BoundingVolume) {
            return this.intersects((BoundingVolume)other) ? 1 : 0;
        }
        throw new UnsupportedCollisionException();
    }

    @Override
    public boolean contains(Vector3f point) {
        return this.center.distanceSquared(point) < this.getRadius() * this.getRadius();
    }

    @Override
    public boolean intersects(Vector3f point) {
        return this.center.distanceSquared(point) <= this.getRadius() * this.getRadius();
    }

    @Override
    public float distanceToEdge(Vector3f point) {
        return this.center.distance(point) - this.radius;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        try {
            e.getCapsule(this).write(this.radius, "radius", 0.0f);
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "write(JMEExporter)", "Exception", ex);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        try {
            this.radius = importer.getCapsule(this).readFloat("radius", 0.0f);
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "read(JMEImporter)", "Exception", ex);
        }
    }

    @Override
    public float getVolume() {
        return 4.1887903f * this.radius * this.radius * this.radius;
    }
}

