/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimTrack;
import com.jme3.anim.interpolator.FrameInterpolator;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.animation.CompactQuaternionArray;
import com.jme3.animation.CompactVector3Array;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public class TransformTrack
implements AnimTrack<Transform> {
    private double length;
    private FrameInterpolator interpolator = null;
    private HasLocalTransform target;
    private CompactVector3Array translations;
    private CompactQuaternionArray rotations;
    private CompactVector3Array scales;
    private float[] times;

    protected TransformTrack() {
    }

    public TransformTrack(HasLocalTransform target, float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        this.target = target;
        this.setKeyframes(times, translations, rotations, scales);
    }

    public Quaternion[] getRotations() {
        return this.rotations == null ? null : (Quaternion[])this.rotations.toObjectArray();
    }

    public Vector3f[] getScales() {
        return this.scales == null ? null : (Vector3f[])this.scales.toObjectArray();
    }

    public float[] getTimes() {
        return this.times;
    }

    public Vector3f[] getTranslations() {
        return this.translations == null ? null : (Vector3f[])this.translations.toObjectArray();
    }

    public void setTimes(float[] times) {
        if (times == null || times.length == 0) {
            throw new IllegalArgumentException("No keyframe times were provided.");
        }
        this.times = times;
        this.length = times[times.length - 1] - times[0];
    }

    public void setKeyframesTranslation(Vector3f[] translations) {
        if (this.times == null) {
            throw new IllegalStateException("TransformTrack lacks keyframe times.  Please invoke setTimes() first.");
        }
        if (translations == null || translations.length == 0) {
            throw new IllegalArgumentException("No translations were provided.");
        }
        this.translations = new CompactVector3Array();
        this.translations.add(translations);
        this.translations.freeze();
        assert (this.times != null && this.times.length == translations.length);
    }

    public void setKeyframesScale(Vector3f[] scales) {
        if (this.times == null) {
            throw new IllegalStateException("TransformTrack lacks keyframe times.  Please invoke setTimes() first.");
        }
        if (scales == null || scales.length == 0) {
            throw new IllegalArgumentException("No scale vectors were provided.");
        }
        this.scales = new CompactVector3Array();
        this.scales.add(scales);
        this.scales.freeze();
        assert (this.times != null && this.times.length == scales.length);
    }

    public void setKeyframesRotation(Quaternion[] rotations) {
        if (this.times == null) {
            throw new IllegalStateException("TransformTrack lacks keyframe times.  Please invoke setTimes() first.");
        }
        if (rotations == null || rotations.length == 0) {
            throw new IllegalArgumentException("No rotations were provided.");
        }
        this.rotations = new CompactQuaternionArray();
        this.rotations.add(rotations);
        this.rotations.freeze();
        assert (this.times != null && this.times.length == rotations.length);
    }

    public void setKeyframes(float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        if (times != null) {
            this.setTimes(times);
        }
        if (translations != null) {
            this.setKeyframesTranslation(translations);
        }
        if (rotations != null) {
            this.setKeyframesRotation(rotations);
        }
        if (scales != null) {
            this.setKeyframesScale(scales);
        }
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void getDataAtTime(double t, Transform transform) {
        float time = (float)t;
        int lastFrame = this.times.length - 1;
        if (time < 0.0f || lastFrame == 0) {
            if (this.translations != null) {
                this.translations.get(0, transform.getTranslation());
            }
            if (this.rotations != null) {
                this.rotations.get(0, transform.getRotation());
            }
            if (this.scales != null) {
                this.scales.get(0, transform.getScale());
            }
            return;
        }
        int startFrame = 0;
        int endFrame = 1;
        float blend = 0.0f;
        if (time >= this.times[lastFrame]) {
            startFrame = lastFrame;
            float inferredInterval = this.times[lastFrame] - this.times[lastFrame - 1];
            if (inferredInterval > 0.0f) {
                blend = (time - this.times[startFrame]) / inferredInterval;
            }
        } else {
            for (int i = 0; i < lastFrame && this.times[i] < time; ++i) {
                startFrame = i;
                endFrame = i + 1;
            }
            blend = (time - this.times[startFrame]) / (this.times[endFrame] - this.times[startFrame]);
        }
        FrameInterpolator fi = this.interpolator == null ? FrameInterpolator.getThreadDefault() : this.interpolator;
        Transform interpolated = fi.interpolate(blend, startFrame, this.translations, this.rotations, this.scales, this.times);
        if (this.translations != null) {
            transform.setTranslation(interpolated.getTranslation());
        }
        if (this.rotations != null) {
            transform.setRotation(interpolated.getRotation());
        }
        if (this.scales != null) {
            transform.setScale(interpolated.getScale());
        }
    }

    public void setFrameInterpolator(FrameInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public HasLocalTransform getTarget() {
        return this.target;
    }

    public void setTarget(HasLocalTransform target) {
        this.target = target;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.translations, "translations", null);
        oc.write(this.rotations, "rotations", null);
        oc.write(this.times, "times", (float[])null);
        oc.write(this.scales, "scales", null);
        oc.write(this.target, "target", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.translations = (CompactVector3Array)ic.readSavable("translations", null);
        this.rotations = (CompactQuaternionArray)ic.readSavable("rotations", null);
        this.times = ic.readFloatArray("times", null);
        this.scales = (CompactVector3Array)ic.readSavable("scales", null);
        this.target = (HasLocalTransform)ic.readSavable("target", null);
        this.setTimes(this.times);
    }

    @Override
    public TransformTrack jmeClone() {
        try {
            TransformTrack clone = (TransformTrack)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.target = cloner.clone(this.target);
    }
}

